/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.crowd;

import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.crowd.PartialCrowdEntityXmlMapper;
import com.atlassian.crowd.dao.group.GroupDAOHibernate;
import com.atlassian.crowd.dao.membership.MembershipDAOHibernate;
import com.atlassian.crowd.dao.user.UserDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.membership.InternalMembership;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.UserTemplate;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="crowdMemberships", itemNodeName="membership")
public class MembershipMapper
extends PartialCrowdEntityXmlMapper<InternalMembership, InternalMembership>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(MembershipMapper.class);
    private static final Set<DirectoryType> INCLUDED_DIRECTORY_TYPES = EnumSet.of(DirectoryType.INTERNAL, DirectoryType.DELEGATING, DirectoryType.CONNECTOR);
    private final MembershipDAOHibernate membershipDAO;
    private final DirectoryDao directoryDAO;
    private final UserDAOHibernate userDAO;
    private final GroupDAOHibernate groupDAO;
    protected static final String MEMBERSHIP_XML_ROOT = "crowdMemberships";
    private static final String MEMBERSHIP_XML_NODE = "membership";
    private static final String MEMBERSHIP_XML_DIRECTORY_ID = "directoryId";
    private static final String MEMBERSHIP_XML_PARENT_NAME = "parentName";
    private static final String MEMBERSHIP_XML_CHILD_NAME = "childName";
    private static final String MEMBERSHIP_XML_PARENT_ID = "parentId";
    private static final String MEMBERSHIP_XML_CHILD_ID = "childId";
    private static final String MEMBERSHIP_XML_MEMBERSHIP_TYPE = "membershipType";
    private static final String MEMBERSHIP_XML_MEMBERSHIP_GROUP_TYPE = "groupType";
    private static Constructor<InternalMembership> internalMembershipConstructor;
    private static Method setId;
    private static Method setDirectory;
    private static Method setChildId;
    private static Method setChildName;
    private static Method setParentId;
    private static Method setParentName;
    private static Method setMembershipType;
    private static Method setGroupType;
    private static Method setCreatedDate;

    public MembershipMapper(SessionFactory sessionFactory, TransactionOperations ops, DirectoryManager directoryManager, MembershipDAOHibernate membershipDAO, DirectoryDao directoryDAO, UserDAOHibernate userDAO, GroupDAOHibernate groupDAO) {
        super(sessionFactory, ops, directoryManager, INCLUDED_DIRECTORY_TYPES);
        this.membershipDAO = membershipDAO;
        this.directoryDAO = directoryDAO;
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
    }

    @Override
    @NotNull
    protected InternalMembership createItemInstance(SMInputCursor inputCursor) throws Exception {
        return internalMembershipConstructor.newInstance(new Object[0]);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.findAllExportableMemberships(), exportDetailsBean);
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull InternalMembership membership, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, membership, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append("id", membership.getId()).append(MEMBERSHIP_XML_DIRECTORY_ID, membership.getDirectory().getId()).append(MEMBERSHIP_XML_PARENT_NAME, membership.getParentName()).append(MEMBERSHIP_XML_CHILD_NAME, membership.getChildName()).append(MEMBERSHIP_XML_PARENT_ID, membership.getParentId()).append(MEMBERSHIP_XML_CHILD_ID, membership.getChildId()).append(MEMBERSHIP_XML_MEMBERSHIP_TYPE, (Enum)membership.getMembershipType()).append(MEMBERSHIP_XML_MEMBERSHIP_GROUP_TYPE, (Enum)membership.getGroupType()).appendIfNotNull("createdDate", membership.getCreatedDate());
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXml(inputCursor);
    }

    @Override
    protected void importProperties(@NotNull InternalMembership object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        switch (inputCursor.getLocalName()) {
            case "id": {
                setId.invoke((Object)object, inputCursor.getElemLongValue());
                break;
            }
            case "directoryId": {
                Directory directoryReference = this.directoryDAO.findById(inputCursor.getElemLongValue());
                setDirectory.invoke((Object)object, new DirectoryImpl(directoryReference));
                break;
            }
            case "childId": {
                setChildId.invoke((Object)object, inputCursor.getElemLongValue());
                break;
            }
            case "parentId": {
                setParentId.invoke((Object)object, inputCursor.getElemLongValue());
                break;
            }
            case "childName": {
                setChildName.invoke((Object)object, inputCursor.getElemStringValue());
                break;
            }
            case "parentName": {
                setParentName.invoke((Object)object, inputCursor.getElemStringValue());
                break;
            }
            case "membershipType": {
                setMembershipType.invoke((Object)object, MembershipType.valueOf((String)inputCursor.getElemStringValue()));
                break;
            }
            case "groupType": {
                setGroupType.invoke((Object)object, GroupType.valueOf((String)inputCursor.getElemStringValue()));
                break;
            }
            case "createdDate": {
                setCreatedDate.invoke((Object)object, MapperUtil.parseDateElement(inputCursor.getElemStringValue()));
            }
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<InternalMembership> list, @NotNull InternalMembership membership, long objectIndex, @NotNull Session session) throws Exception {
        if (this.isImportableDirectory(membership.getDirectory())) {
            if (this.isPlaceholderUserNeeded(membership)) {
                InternalUser placeholderUser = MembershipMapper.createPlaceholderUser(membership.getChildId(), membership.getChildName(), membership.getDirectory());
                session.replicate((Object)placeholderUser, ReplicationMode.OVERWRITE);
            } else if (this.isPlaceholderChildGroupNeeded(membership)) {
                InternalGroup placeholderGroup = MembershipMapper.createPlaceholderGroup(membership.getChildId(), membership.getChildName(), membership.getDirectory());
                session.replicate((Object)placeholderGroup, ReplicationMode.OVERWRITE);
            } else if (this.isPlaceholderParentGroupNeeded(membership)) {
                InternalGroup placeholderGroup = MembershipMapper.createPlaceholderGroup(membership.getParentId(), membership.getParentName(), membership.getDirectory());
                session.replicate((Object)placeholderGroup, ReplicationMode.OVERWRITE);
            }
            session.replicate((Object)membership, ReplicationMode.OVERWRITE);
        }
    }

    private Iterable<InternalMembership> findAllExportableMemberships() {
        List<Directory> exportableDirectories = this.findAllExportableDirectories();
        Predicate<Directory> requiresExportOfNonLocalGroups = directory -> this.isExportOfNonLocalGroupsRequired(directory.getType());
        Collection directoriesThatExportAllMemberships = exportableDirectories.stream().filter(requiresExportOfNonLocalGroups).collect(Collectors.toList());
        Collection directoriesThatExportOnlyLocalMemberships = exportableDirectories.stream().filter(requiresExportOfNonLocalGroups.negate()).collect(Collectors.toList());
        return Iterables.concat((Iterable)this.membershipDAO.findAll(directoriesThatExportAllMemberships), (Iterable)this.membershipDAO.findAllLocal(directoriesThatExportOnlyLocalMemberships));
    }

    private static InternalUser createPlaceholderUser(Long id, String name, Directory directory) {
        InternalEntityTemplate internalEntityTemplate = new InternalEntityTemplate(id, name, true, new Date(), new Date());
        UserTemplate userTemplate = new UserTemplate(name, directory.getId().longValue());
        userTemplate.setActive(true);
        return new InternalUser(internalEntityTemplate, directory, userTemplate, PasswordCredential.NONE);
    }

    private static InternalGroup createPlaceholderGroup(Long id, String name, Directory directory) {
        InternalEntityTemplate internalEntityTemplate = new InternalEntityTemplate(id, name, true, new Date(), new Date());
        GroupTemplate groupTemplate = new GroupTemplate(name, directory.getId().longValue());
        groupTemplate.setActive(true);
        return new InternalGroup(internalEntityTemplate, directory, groupTemplate);
    }

    private boolean isPlaceholderUserNeeded(InternalMembership membership) {
        return membership.getMembershipType().equals((Object)MembershipType.GROUP_USER) && !this.userExistsInDirectory(membership.getChildName(), membership.getDirectory());
    }

    private boolean isPlaceholderChildGroupNeeded(InternalMembership membership) {
        return membership.getMembershipType().equals((Object)MembershipType.GROUP_GROUP) && !this.groupExistsInDirectory(membership.getChildName(), membership.getDirectory());
    }

    private boolean isPlaceholderParentGroupNeeded(InternalMembership membership) {
        return membership.getMembershipType().equals((Object)MembershipType.GROUP_GROUP) && !this.groupExistsInDirectory(membership.getParentName(), membership.getDirectory());
    }

    private boolean userExistsInDirectory(String name, Directory directory) {
        try {
            this.userDAO.findByName(directory.getId().longValue(), name);
            return true;
        }
        catch (UserNotFoundException e) {
            return false;
        }
    }

    private boolean groupExistsInDirectory(String name, Directory directory) {
        try {
            this.groupDAO.findByName(directory.getId().longValue(), name);
            return true;
        }
        catch (GroupNotFoundException e) {
            return false;
        }
    }

    static {
        try {
            internalMembershipConstructor = InternalMembership.class.getDeclaredConstructor(new Class[0]);
            internalMembershipConstructor.setAccessible(true);
            setId = InternalMembership.class.getDeclaredMethod("setId", Long.class);
            setId.setAccessible(true);
            setDirectory = InternalMembership.class.getDeclaredMethod("setDirectory", DirectoryImpl.class);
            setDirectory.setAccessible(true);
            setChildId = InternalMembership.class.getDeclaredMethod("setChildId", Long.class);
            setChildId.setAccessible(true);
            setChildName = InternalMembership.class.getDeclaredMethod("setChildName", String.class);
            setChildName.setAccessible(true);
            setParentId = InternalMembership.class.getDeclaredMethod("setParentId", Long.class);
            setParentId.setAccessible(true);
            setParentName = InternalMembership.class.getDeclaredMethod("setParentName", String.class);
            setParentName.setAccessible(true);
            setMembershipType = InternalMembership.class.getDeclaredMethod("setMembershipType", MembershipType.class);
            setMembershipType.setAccessible(true);
            setGroupType = InternalMembership.class.getDeclaredMethod("setGroupType", GroupType.class);
            setGroupType.setAccessible(true);
            setCreatedDate = InternalMembership.class.getDeclaredMethod("setCreatedDate", Date.class);
            setCreatedDate.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception initialising Crowd mapper. Incompatible class change", e);
        }
    }
}

