/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.crowd;

import com.atlassian.bamboo.migration.stream.crowd.CrowdEntityXmlMapper;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.springframework.transaction.support.TransactionOperations;

public abstract class PartialCrowdEntityXmlMapper<T, I extends T>
extends CrowdEntityXmlMapper<T, I> {
    private static final Logger log = Logger.getLogger(PartialCrowdEntityXmlMapper.class);
    private static Set<DirectoryType> DIRECTORY_TYPES_THAT_EXPORT_REMOTE_GROUPS = EnumSet.of(DirectoryType.UNKNOWN, DirectoryType.INTERNAL, DirectoryType.CUSTOM);
    private DirectoryManager directoryManager;
    private final Set<DirectoryType> includedDirectoryTypes;

    public PartialCrowdEntityXmlMapper(SessionFactory sessionFactory, TransactionOperations ops, DirectoryManager directoryManager, Set<DirectoryType> includedDirectoryTypes) {
        super(sessionFactory, ops);
        this.directoryManager = directoryManager;
        this.includedDirectoryTypes = ImmutableSet.copyOf(includedDirectoryTypes);
    }

    protected boolean isImportableDirectory(Directory directory) {
        return this.includedDirectoryTypes.contains(directory.getType());
    }

    protected List<Directory> findAllExportableDirectories() {
        ArrayList<PropertyRestriction> restrictions = new ArrayList<PropertyRestriction>(this.includedDirectoryTypes.size());
        for (DirectoryType type : this.includedDirectoryTypes) {
            restrictions.add(Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)type));
        }
        return this.directoryManager.searchDirectories(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Combine.anyOf(restrictions)).returningAtMost(-1));
    }

    protected boolean isExportOfNonLocalGroupsRequired(DirectoryType directoryType) {
        return DIRECTORY_TYPES_THAT_EXPORT_REMOTE_GROUPS.contains(directoryType);
    }
}

