/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.crowd;

import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.crowd.PartialCrowdEntityXmlMapper;
import com.atlassian.crowd.dao.user.UserDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.InternalDirectoryEntity;
import com.atlassian.crowd.model.InternalEntityAttribute;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.InternalUserAttribute;
import com.atlassian.crowd.model.user.InternalUserCredentialRecord;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="crowdUsers", itemNodeName="user")
public class UserMapper
extends PartialCrowdEntityXmlMapper<InternalUser, InternalUser>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(UserMapper.class);
    private static final Set<DirectoryType> INCLUDED_DIRECTORY_TYPES = EnumSet.of(DirectoryType.INTERNAL, DirectoryType.DELEGATING);
    private final UserDAOHibernate userDAO;
    private final DirectoryDao directoryDAO;
    protected static final String USER_XML_ROOT = "crowdUsers";
    protected static final String USER_XML_NODE = "user";
    private static final String USER_XML_DIRECTORY_ID = "directoryId";
    private static final String USER_XML_FIRST_NAME = "firstName";
    private static final String USER_XML_LAST_NAME = "lastName";
    private static final String USER_XML_DISPLAY_NAME = "displayName";
    private static final String USER_XML_EMAIL = "email";
    private static final String USER_XML_EXTERNAL_ID = "externalId";
    private static final String USER_XML_CREDENTIAL = "credential";
    private static final String USER_XML_CREDENTIAL_RECORDS = "credentialRecords";
    private static final String USER_XML_CREDENTIAL_RECORD = "credentialRecord";
    private static final String USER_XML_ATTRIBUTES = "attributes";
    private static final String USER_XML_ATTRIBUTE = "attribute";
    private static final String USER_XML_ATTRIBUTE_NAME = "name";
    private static final String USER_XML_ATTRIBUTE_VALUE = "value";
    private static Constructor<InternalUser> internalUserConstructor;
    private static Method setDirectory;
    private static Method setFirstName;
    private static Method setLowerFirstName;
    private static Method setLastName;
    private static Method setLowerLastName;
    private static Method setEmailAddress;
    private static Method setLowerEmailAddress;
    private static Method setExternalId;
    private static Method setDisplayName;
    private static Method setLowerDisplayName;
    private static Method setCredential;
    private static Method setAttributes;
    private static Method setCredentialRecords;

    public UserMapper(SessionFactory sessionFactory, TransactionOperations ops, DirectoryManager directoryManager, DirectoryDao directoryDAO, UserDAOHibernate userDAO) {
        super(sessionFactory, ops, directoryManager, INCLUDED_DIRECTORY_TYPES);
        this.directoryDAO = directoryDAO;
        this.userDAO = userDAO;
    }

    @Override
    @NotNull
    protected InternalUser createItemInstance(SMInputCursor inputCursor) throws Exception {
        return internalUserConstructor.newInstance(new Object[0]);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElement rootElement = this.createListRootElement(outputElement);
        List<Directory> directories = this.findAllExportableDirectories();
        for (Directory directory : directories) {
            List users = this.userDAO.search(directory.getId().longValue(), QueryBuilder.queryFor(InternalUser.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
            for (InternalUser user : users) {
                this.exportXml(rootElement, user, exportDetailsBean);
            }
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull InternalUser user, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, user, session, exportDetailsBean);
        SMOutputElementAppender appender = new SMOutputElementAppender(outputElement).append(USER_XML_DIRECTORY_ID, user.getDirectoryId()).appendIfNotBlank(USER_XML_FIRST_NAME, user.getFirstName()).appendIfNotBlank(USER_XML_LAST_NAME, user.getLastName()).appendIfNotBlank(USER_XML_DISPLAY_NAME, user.getDisplayName()).appendIfNotBlank(USER_XML_EMAIL, user.getEmailAddress()).appendIfNotBlank(USER_XML_EXTERNAL_ID, user.getExternalId());
        if (user.getCredential() != null) {
            appender.appendIfNotBlank(USER_XML_CREDENTIAL, user.getCredential().getCredential());
        }
        new CredentialsRecordsMapper(this.getSessionFactory(), this.transactionOperations, user).exportListXml(session, outputElement, user.getCredentialRecords(), exportDetailsBean);
        new UserAttributesMapper(this.getSessionFactory(), this.transactionOperations, user).exportListXml(session, outputElement, user.getAttributes(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXml(inputCursor);
    }

    @Override
    protected void importProperties(@NotNull InternalUser object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        switch (inputCursor.getLocalName()) {
            case "directoryId": {
                Directory directory = this.directoryDAO.findById(inputCursor.getElemLongValue());
                setDirectory.invoke((Object)object, directory);
                break;
            }
            case "firstName": {
                String firstName = inputCursor.getElemStringValue();
                setFirstName.invoke((Object)object, firstName);
                setLowerFirstName.invoke((Object)object, IdentifierUtils.toLowerCase((String)firstName));
                break;
            }
            case "lastName": {
                String lastName = inputCursor.getElemStringValue();
                setLastName.invoke((Object)object, lastName);
                setLowerLastName.invoke((Object)object, IdentifierUtils.toLowerCase((String)lastName));
                break;
            }
            case "displayName": {
                String displayName = inputCursor.getElemStringValue();
                setDisplayName.invoke((Object)object, displayName);
                setLowerDisplayName.invoke((Object)object, IdentifierUtils.toLowerCase((String)displayName));
                break;
            }
            case "email": {
                String email = inputCursor.getElemStringValue();
                setEmailAddress.invoke((Object)object, email);
                setLowerEmailAddress.invoke((Object)object, email.toLowerCase(Locale.ENGLISH));
                break;
            }
            case "externalId": {
                setExternalId.invoke((Object)object, inputCursor.getElemStringValue());
                break;
            }
            case "credential": {
                setCredential.invoke((Object)object, new PasswordCredential(inputCursor.getElemStringValue(), true));
                break;
            }
            case "attributes": {
                setAttributes.invoke((Object)object, new HashSet(new UserAttributesMapper(this.getSessionFactory(), this.transactionOperations, object).importListXml(inputCursor)));
                break;
            }
            case "credentialRecords": {
                setCredentialRecords.invoke((Object)object, new CredentialsRecordsMapper(this.getSessionFactory(), this.transactionOperations, object).importListXml(inputCursor));
            }
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<InternalUser> list, @NotNull InternalUser object, long objectIndex, @NotNull Session session) throws Exception {
        session.replicate((Object)object, ReplicationMode.OVERWRITE);
        for (InternalUserAttribute userAttribute : object.getAttributes()) {
            session.replicate((Object)userAttribute, ReplicationMode.OVERWRITE);
        }
    }

    static {
        try {
            internalUserConstructor = InternalUser.class.getDeclaredConstructor(new Class[0]);
            internalUserConstructor.setAccessible(true);
            setDirectory = InternalDirectoryEntity.class.getDeclaredMethod("setDirectory", Directory.class);
            setDirectory.setAccessible(true);
            setFirstName = InternalUser.class.getDeclaredMethod("setFirstName", String.class);
            setFirstName.setAccessible(true);
            setLowerFirstName = InternalUser.class.getDeclaredMethod("setLowerFirstName", String.class);
            setLowerFirstName.setAccessible(true);
            setLastName = InternalUser.class.getDeclaredMethod("setLastName", String.class);
            setLastName.setAccessible(true);
            setLowerLastName = InternalUser.class.getDeclaredMethod("setLowerLastName", String.class);
            setLowerLastName.setAccessible(true);
            setEmailAddress = InternalUser.class.getDeclaredMethod("setEmailAddress", String.class);
            setEmailAddress.setAccessible(true);
            setLowerEmailAddress = InternalUser.class.getDeclaredMethod("setLowerEmailAddress", String.class);
            setLowerEmailAddress.setAccessible(true);
            setExternalId = InternalUser.class.getDeclaredMethod("setExternalId", String.class);
            setExternalId.setAccessible(true);
            setDisplayName = InternalUser.class.getDeclaredMethod("setDisplayName", String.class);
            setDisplayName.setAccessible(true);
            setLowerDisplayName = InternalUser.class.getDeclaredMethod("setLowerDisplayName", String.class);
            setLowerDisplayName.setAccessible(true);
            setCredential = InternalUser.class.getDeclaredMethod("setCredential", PasswordCredential.class);
            setCredential.setAccessible(true);
            setAttributes = InternalDirectoryEntity.class.getDeclaredMethod("setAttributes", Set.class);
            setAttributes.setAccessible(true);
            setCredentialRecords = InternalUser.class.getDeclaredMethod("setCredentialRecords", List.class);
            setCredentialRecords.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Exception initialising Crowd mapper. Incompatible class change", e);
        }
    }

    @ListMapper(rootNodeName="credentialRecords", itemNodeName="credentialRecord")
    @VisibleForTesting
    protected static class CredentialsRecordsMapper
    extends BambooStAXMappingListHelperAbstractImpl<InternalUserCredentialRecord, InternalUserCredentialRecord> {
        private final InternalUser user;
        private static Constructor<InternalUserCredentialRecord> constructor;
        private static Method setId;
        private static Method setPasswordHash;
        private static Method setUser;

        protected CredentialsRecordsMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations, @NotNull InternalUser user) {
            super(sessionFactory, transactionOperations);
            this.user = user;
        }

        @Override
        @NotNull
        protected InternalUserCredentialRecord createItemInstance(SMInputCursor inputCursor) throws Exception {
            return constructor.newInstance(new Object[0]);
        }

        @Override
        protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull InternalUserCredentialRecord credential, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
            new SMOutputElementAppender(outputElement).append("id", credential.getId()).append(UserMapper.USER_XML_CREDENTIAL, credential.getPasswordHash());
        }

        @Override
        protected void importProperties(@NotNull InternalUserCredentialRecord entry, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
            String elementName;
            switch (elementName = inputCursor.getLocalName()) {
                case "id": {
                    setId.invoke((Object)entry, inputCursor.getElemLongValue());
                    break;
                }
                case "credential": {
                    setPasswordHash.invoke((Object)entry, inputCursor.getElemStringValue());
                }
            }
        }

        @Override
        public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<InternalUserCredentialRecord> list, @NotNull InternalUserCredentialRecord object, long objectIndex, @NotNull Session session) throws Exception {
            setUser.invoke((Object)object, this.user);
        }

        static {
            try {
                constructor = InternalUserCredentialRecord.class.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                setId = InternalUserCredentialRecord.class.getDeclaredMethod("setId", Long.class);
                setId.setAccessible(true);
                setPasswordHash = InternalUserCredentialRecord.class.getDeclaredMethod("setPasswordHash", String.class);
                setPasswordHash.setAccessible(true);
                setUser = InternalUserCredentialRecord.class.getDeclaredMethod("setUser", InternalUser.class);
                setUser.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Exception initialising Crowd mapper. Incompatible class change", e);
            }
        }
    }

    @ListMapper(rootNodeName="attributes", itemNodeName="attribute")
    protected static class UserAttributesMapper
    extends BambooStAXMappingListHelperAbstractImpl<InternalUserAttribute, InternalUserAttribute> {
        private final InternalUser user;
        private static Constructor<InternalUserAttribute> constructor;
        private static Method setId;
        private static Method setUser;
        private static Method setDirectory;

        protected UserAttributesMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations, @NotNull InternalUser user) {
            super(sessionFactory, transactionOperations);
            this.user = user;
        }

        @Override
        @NotNull
        protected InternalUserAttribute createItemInstance(SMInputCursor inputCursor) throws Exception {
            return constructor.newInstance(new Object[0]);
        }

        @Override
        protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull InternalUserAttribute attribute, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
            new SMOutputElementAppender(outputElement).append("id", attribute.getId()).append(UserMapper.USER_XML_ATTRIBUTE_NAME, attribute.getName()).append(UserMapper.USER_XML_ATTRIBUTE_VALUE, attribute.getValue());
        }

        @Override
        protected void importProperties(@NotNull InternalUserAttribute entry, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
            String elementName;
            switch (elementName = inputCursor.getLocalName()) {
                case "id": {
                    setId.invoke((Object)entry, inputCursor.getElemLongValue());
                    break;
                }
                case "name": {
                    entry.setName(inputCursor.getElemStringValue());
                    break;
                }
                case "value": {
                    entry.setValue(inputCursor.getElemStringValue());
                }
            }
        }

        @Override
        public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<InternalUserAttribute> list, @NotNull InternalUserAttribute object, long objectIndex, @NotNull Session session) throws Exception {
            setUser.invoke((Object)object, this.user);
            setDirectory.invoke((Object)object, this.user.getDirectory());
        }

        static {
            try {
                constructor = InternalUserAttribute.class.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                setId = InternalEntityAttribute.class.getDeclaredMethod("setId", Long.class);
                setId.setAccessible(true);
                setUser = InternalUserAttribute.class.getDeclaredMethod("setUser", InternalUser.class);
                setUser.setAccessible(true);
                setDirectory = InternalUserAttribute.class.getDeclaredMethod("setDirectory", Directory.class);
                setDirectory.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Exception initialising Crowd mapper. Incompatible class change", e);
            }
        }
    }
}

