/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.notifications;

import com.atlassian.bamboo.migration.BambooStAXMappingHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ItemMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.NotificationRuleImpl;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ItemMapper(rootNodeName="notification")
public class NotificationRuleMapper
extends BambooStAXMappingHelperAbstractImpl<NotificationRule, NotificationRule> {
    private static final Logger log = Logger.getLogger(NotificationRuleMapper.class);
    private static final String CONDITION_KEY = "conditionKey";
    private static final String CONDITION_DATA = "conditionData";
    private static final String RECIPIENT_TYPE = "recipientType";
    private static final String RECIPIENT_DETAILS = "recipientDetails";

    public NotificationRuleMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
    }

    @Override
    @NotNull
    protected NotificationRule createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new NotificationRuleImpl();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull NotificationRule notificationRule, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, notificationRule, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).appendIfNotBlank(CONDITION_KEY, notificationRule.getConditionKey()).appendIfNotBlank(CONDITION_DATA, notificationRule.getConditionData()).appendIfNotBlank(RECIPIENT_TYPE, notificationRule.getRecipientType()).appendIfNotBlank(RECIPIENT_DETAILS, notificationRule.getRecipient());
    }

    @Override
    protected void importProperties(@NotNull NotificationRule notificationRule, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(notificationRule, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (CONDITION_KEY.equals(elementLocalName)) {
            notificationRule.setConditionKey(inputCursor.getElemStringValue());
        } else if (CONDITION_DATA.equals(elementLocalName)) {
            notificationRule.setConditionData(inputCursor.getElemStringValue());
        } else if (RECIPIENT_TYPE.equals(elementLocalName)) {
            notificationRule.setRecipientType(inputCursor.getElemStringValue());
        } else if (RECIPIENT_DETAILS.equals(elementLocalName)) {
            notificationRule.setRecipient(inputCursor.getElemStringValue());
        }
    }
}

