/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.notifications;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXMappingHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ItemMapper;
import com.atlassian.bamboo.migration.stream.notifications.NotificationRuleMapper;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.NotificationSet;
import com.atlassian.bamboo.notification.NotificationSetImpl;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ItemMapper(rootNodeName="notificationSet")
public class NotificationSetMapper
extends BambooStAXMappingHelperAbstractImpl<NotificationSet, NotificationSet> {
    private final NotificationRuleMapper notificationRuleMapper;

    public NotificationSetMapper(SessionFactory sessionFactory, NotificationRuleMapper notificationRuleMapper, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.notificationRuleMapper = notificationRuleMapper;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull NotificationSet notificationSet, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, notificationSet, session, exportDetailsBean);
        for (NotificationRule rule : notificationSet.getNotificationRules()) {
            this.notificationRuleMapper.exportXml(session, outputElement, rule, exportDetailsBean);
        }
    }

    @Override
    protected void importProperties(@NotNull NotificationSet notificationSet, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(notificationSet, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if ("id".equals(elementLocalName)) {
            this.saveBambooObject(session, (BambooIdProvider)notificationSet);
        } else if (this.notificationRuleMapper.getXmlRootNodeName().equals(elementLocalName)) {
            NotificationRule notificationRule = (NotificationRule)this.notificationRuleMapper.importXml(session, inputCursor);
            notificationSet.addNotification(notificationRule);
            this.saveBambooObject(session, (BambooIdProvider)notificationRule);
        }
    }

    @Override
    @NotNull
    protected NotificationSet createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new NotificationSetImpl();
    }
}

