/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.requirements;

import com.atlassian.bamboo.migration.BambooStAXMappingHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ItemMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ItemMapper(rootNodeName="requirement")
public class RequirementMapper
extends BambooStAXMappingHelperAbstractImpl<Requirement, Requirement> {
    private static final Logger log = Logger.getLogger(RequirementMapper.class);
    static final String BUILD_XML_REQUIREMENT_KEY = "key";
    static final String BUILD_XML_REQUIREMENT_VALUE = "value";
    static final String BUILD_XML_REQUIREMENT_REGEX = "regex";
    static final String BUILD_XML_REQUIREMENT_READONLY = "readOnly";
    static final String BUILD_XML_REQUIREMENT_PLUGIN_MODULE_KEY = "pluginModuleKey";
    static final String BUILD_XML_REQUIREMENT_OWNER_ID = "ownerId";

    public RequirementMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
    }

    @Override
    @NotNull
    protected Requirement createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new RequirementImpl();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull Requirement requirement, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, requirement, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(BUILD_XML_REQUIREMENT_KEY, requirement.getKey()).appendIfNotBlank(BUILD_XML_REQUIREMENT_PLUGIN_MODULE_KEY, requirement.getPluginModuleKey()).append(BUILD_XML_REQUIREMENT_OWNER_ID, Long.toString(requirement.getOwnerId()));
        SMOutputElement valueElement = outputElement.addElement(BUILD_XML_REQUIREMENT_VALUE);
        valueElement.addAttribute(BUILD_XML_REQUIREMENT_READONLY, Boolean.toString(requirement.isReadonly()));
        valueElement.addAttribute(BUILD_XML_REQUIREMENT_REGEX, Boolean.toString(requirement.isRegexMatch()));
        valueElement.addCharacters(requirement.getMatchValue());
    }

    @Override
    protected void importProperties(@NotNull Requirement requirement, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(requirement, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (BUILD_XML_REQUIREMENT_KEY.equals(elementLocalName)) {
            requirement.setKey(inputCursor.getElemStringValue());
        } else if (BUILD_XML_REQUIREMENT_VALUE.equals(elementLocalName)) {
            requirement.setReadonly(Boolean.valueOf(Boolean.parseBoolean(inputCursor.getAttrValue(BUILD_XML_REQUIREMENT_READONLY))));
            ((RequirementImpl)requirement).setRegexMatch(Boolean.valueOf(Boolean.parseBoolean(inputCursor.getAttrValue(BUILD_XML_REQUIREMENT_REGEX))));
            ((RequirementImpl)requirement).setMatchValue(inputCursor.getElemStringValue());
        } else if (BUILD_XML_REQUIREMENT_OWNER_ID.equals(elementLocalName)) {
            requirement.setOwnerId(inputCursor.getElemLongValue());
        } else if (BUILD_XML_REQUIREMENT_PLUGIN_MODULE_KEY.equals(elementLocalName)) {
            requirement.setPluginModuleKey(inputCursor.getElemStringValue());
        }
    }
}

