/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.requirements;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXMappingHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ItemMapper;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.stream.requirements.RequirementMapper;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSetImpl;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ItemMapper(rootNodeName="requirementSet")
public class RequirementSetMapper
extends BambooStAXMappingHelperAbstractImpl<RequirementSet, RequirementSet> {
    private static final Logger log = Logger.getLogger(RequirementSetMapper.class);
    private final RequirementMapper requirementMapper;

    public RequirementSetMapper(SessionFactory sessionFactory, RequirementMapper requirementMapper, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.requirementMapper = requirementMapper;
    }

    @Override
    @NotNull
    protected RequirementSet createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new RequirementSetImpl();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull RequirementSet requirementSet, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, requirementSet, session, exportDetailsBean);
        for (Requirement requirement : requirementSet.getRequirements()) {
            this.requirementMapper.exportXml(session, outputElement, requirement, exportDetailsBean);
        }
    }

    @Override
    protected void importProperties(@NotNull RequirementSet requirementSet, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(requirementSet, inputCursor, session);
        String elementName = inputCursor.getLocalName();
        if ("id".equals(elementName)) {
            this.saveBambooObject(session, (BambooIdProvider)requirementSet);
        } else if (MapperUtil.matchesElement(this.requirementMapper, elementName)) {
            Requirement requirement = (Requirement)this.requirementMapper.importXml(session, inputCursor);
            requirementSet.addRequirement(requirement);
            this.saveBambooObject(session, (BambooIdProvider)requirement);
            session.update((Object)requirementSet);
        }
    }
}

