/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.script;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.core.ScriptImpl;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.dao.ScriptDao;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="scripts", itemNodeName="script")
public class ScriptMapper
extends BambooStAXMappingListHelperAbstractImpl<ScriptImpl, ScriptImpl>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(ScriptMapper.class);
    private static final String BODY = "body";
    private ScriptDao scriptDao;

    public ScriptMapper(SessionFactory sessionFactory, ScriptDao scriptDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_TRANSACTION, transactionOperations);
        this.scriptDao = scriptDao;
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<ScriptImpl> list, @NotNull ScriptImpl object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)object);
    }

    @Override
    @NotNull
    protected ScriptImpl createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new ScriptImpl();
    }

    @Override
    protected void importProperties(@NotNull ScriptImpl script, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        super.importProperties(script, inputCursor, session);
        if (BODY.equals(elementLocalName)) {
            script.setBody(inputCursor.getElemStringValue());
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull ScriptImpl object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).appendCData(BODY, object.getBody());
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.scriptDao.findAll(ScriptImpl.class), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.clear();
    }
}

