/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.userdata;

import com.atlassian.bamboo.accesstoken.AccessTokenDao;
import com.atlassian.bamboo.accesstoken.MutableAccessToken;
import com.atlassian.bamboo.accesstoken.MutableAccessTokenImpl;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="accessTokens", itemNodeName="accessToken")
public class AccessTokenMapper
extends BambooStAXMappingListHelperAbstractImpl<MutableAccessToken, MutableAccessToken>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(AccessTokenMapper.class);
    private static final String HASHED_TOKEN = "hashedToken";
    private static final String TOKEN_ID = "tokenId";
    private static final String TOKEN_NAME = "name";
    private static final String USER_NAME = "username";
    private static final String CREATED_DATE = "createdDate";
    private static final String PERMISSIONS_MASK = "permissionsMask";
    private static final String DAYS_UNTIL_EXPIRY = "daysUntilExpiry";
    private final AccessTokenDao accessTokenDao;

    public AccessTokenMapper(SessionFactory sessionFactory, TransactionOperations transactionOperations, AccessTokenDao accessTokenDao) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.accessTokenDao = accessTokenDao;
    }

    @Override
    @NotNull
    protected MutableAccessToken createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new MutableAccessTokenImpl();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull MutableAccessToken object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).appendIfNotBlank(HASHED_TOKEN, object.getHashedToken()).appendIfNotBlank(TOKEN_ID, object.getTokenId()).appendIfNotBlank(TOKEN_NAME, object.getName()).appendIfNotBlank(USER_NAME, object.getUserName()).appendIfNotNull(CREATED_DATE, object.getCreationDate()).append(PERMISSIONS_MASK, object.getPermissionsMask()).appendIfNotNull(DAYS_UNTIL_EXPIRY, object.getDaysUntilExpiry());
    }

    @Override
    protected void importProperties(@NotNull MutableAccessToken object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName;
        super.importProperties(object, inputCursor, session);
        switch (elementLocalName = inputCursor.getLocalName()) {
            case "hashedToken": {
                object.setHashedToken(inputCursor.getElemStringValue());
                break;
            }
            case "tokenId": {
                object.setTokenId(inputCursor.getElemStringValue());
                break;
            }
            case "name": {
                object.setName(inputCursor.getElemStringValue());
                break;
            }
            case "username": {
                object.setUserName(inputCursor.getElemStringValue());
                break;
            }
            case "createdDate": {
                object.setCreationDate(MapperUtil.parseDateElement(inputCursor.getElemStringValue()));
                break;
            }
            case "permissionsMask": {
                object.setPermissionsMask(inputCursor.getElemIntValue());
                break;
            }
            case "daysUntilExpiry": {
                object.setDaysUntilExpiry(Integer.valueOf(inputCursor.getElemIntValue()));
            }
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<MutableAccessToken> artifactDefinitions, @NotNull MutableAccessToken object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)object);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.accessTokenDao.scrollTokensForExport(MapperUtil.exportXmlConsumer(this, rootElement, exportDetailsBean));
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXml(inputCursor);
    }
}

