/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.userdata;

import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.stream.userdata.ImportedUsers;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.user.ExternalEntity;
import com.atlassian.user.impl.hibernate3.DefaultHibernateExternalEntity;
import java.util.List;
import javax.inject.Inject;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class ExternalEntityMapper
extends BambooStAXMappingListHelperAbstractImpl<ExternalEntity, ExternalEntity>
implements BambooStAXRootMapper {
    static final String EXTERNAL_ENTITY_XML_ROOT = "externalEntities";
    static final String EXTERNAL_ENTITY_XML_NODE = "externalEntity";
    static final String EXTERNAL_ENTITY_XML_ID = "id";
    static final String EXTERNAL_ENTITY_XML_NAME = "name";
    static final String EXTERNAL_ENTITY_XML_TYPE = "type";
    @Inject
    ImportedUsers importedUsers;

    public ExternalEntityMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
    }

    @Override
    @NotNull
    protected ExternalEntity createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new DefaultHibernateExternalEntity();
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return EXTERNAL_ENTITY_XML_NODE;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return EXTERNAL_ENTITY_XML_ROOT;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull ExternalEntity object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
    }

    @Override
    protected void importProperties(@NotNull ExternalEntity object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        DefaultHibernateExternalEntity entity = (DefaultHibernateExternalEntity)Narrow.downTo((Object)object, DefaultHibernateExternalEntity.class);
        if (entity != null) {
            String elementLocalName = inputCursor.getLocalName();
            if (EXTERNAL_ENTITY_XML_ID.equals(elementLocalName)) {
                entity.setId(inputCursor.getElemLongValue());
            } else if (EXTERNAL_ENTITY_XML_NAME.equals(elementLocalName)) {
                entity.setName(inputCursor.getElemStringValue());
            } else if (EXTERNAL_ENTITY_XML_TYPE.equals(elementLocalName)) {
                entity.setType(inputCursor.getElemStringValue());
            }
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<ExternalEntity> externalEntities, @NotNull ExternalEntity object, long objectIndex, @NotNull Session session) throws Exception {
        this.importedUsers.remember(object);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        super.importListXml(inputCursor);
    }
}

