/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.userdata;

import com.atlassian.user.ExternalEntity;
import com.atlassian.user.impl.hibernate3.DefaultHibernateUser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class ImportedUsers {
    private final Map<Long, String> externalUserIdToUser = new HashMap<Long, String>();
    private final Map<Long, String> localUserIdToUser = new HashMap<Long, String>();

    ImportedUsers() {
    }

    public void remember(ExternalEntity user) {
        this.externalUserIdToUser.put(user.getId(), user.getName());
    }

    public void remember(DefaultHibernateUser hibernateUser) {
        this.localUserIdToUser.put(hibernateUser.getId(), hibernateUser.getName());
    }

    Set<String> findAllExternalUsers(List<Long> userIds) {
        return ImportedUsers.toUserNames(userIds, this.externalUserIdToUser::get);
    }

    Set<String> findAllLocalUsers(List<Long> userIds) {
        return ImportedUsers.toUserNames(userIds, this.localUserIdToUser::get);
    }

    private static Set<String> toUserNames(List<Long> userIds, Function<Long, String> toUserName) {
        return userIds.stream().map(toUserName).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

