/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.userdata;

import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.stream.userdata.ImportedUsers;
import com.atlassian.bamboo.migration.stream.userdata.LocalUserMapper;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.BambooSuppliers;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.user.impl.hibernate3.DefaultHibernateGroup;
import com.google.gson.Gson;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

public class LocalGroupMapper
extends BambooStAXMappingListHelperAbstractImpl<DefaultHibernateGroup, DefaultHibernateGroup>
implements BambooStAXRootMapper {
    private static final String XML_ROOT = "localGroups";
    private static final String XML_NODE = "localGroup";
    private static final String XML_ID = "id";
    private static final String XML_NAME = "name";
    private static final String XML_LOCAL_MEMBERS = "localMembers";
    private static final String XML_EXTERNAL_MEMBERS = "externalMembers";
    private static final String XML_MEMBER = "member";
    private final GroupMemberMapper localGroupMemberMapper;
    private final GroupMemberMapper externalGroupMemberMapper;
    @Inject
    private ImportedUsers importedUsers;
    @Inject
    private MembershipDao membershipDao;
    @Inject
    private GroupDao groupDao;
    @Inject
    private CrowdDirectoryService crowdDirectoryService;
    @Inject
    private BootstrapManager bootstrapManager;
    private final BambooSuppliers.ResettableMemoizingSupplier<Directory> internalDirectory = BambooSuppliers.memoizeResettably(() -> LocalUserMapper.getInternalDirectory(this.crowdDirectoryService));
    private String groupName;
    private boolean isGroupCreated;
    private Map<String, Set<String>> localGroupMemberships = new HashMap<String, Set<String>>();

    public LocalGroupMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_TRANSACTION, transactionOperations);
        this.localGroupMemberMapper = new GroupMemberMapper(sessionFactory, XML_LOCAL_MEMBERS, transactionOperations);
        this.externalGroupMemberMapper = new GroupMemberMapper(sessionFactory, XML_EXTERNAL_MEMBERS, transactionOperations);
    }

    @Override
    @NotNull
    protected DefaultHibernateGroup createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new DefaultHibernateGroup();
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull DefaultHibernateGroup object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
    }

    @Override
    protected void importProperties(@NotNull DefaultHibernateGroup group, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        @Nullable String elementLocalName = inputCursor.getLocalName();
        if (XML_ID.equals(elementLocalName)) {
            group.setId(inputCursor.getElemLongValue());
        } else if (XML_NAME.equals(elementLocalName)) {
            this.groupName = inputCursor.getElemStringValue();
            this.isGroupCreated = false;
            group.setName(this.groupName);
        } else if (XML_LOCAL_MEMBERS.equals(elementLocalName)) {
            this.ensureInternalDirectoryGroupExists();
            Set<String> userNames = this.importedUsers.findAllLocalUsers(this.localGroupMemberMapper.importListXml(inputCursor));
            for (String userName : userNames) {
                this.membershipDao.addUserToGroup(((Directory)this.internalDirectory.get()).getId().longValue(), userName, group.getName());
            }
        } else if (XML_EXTERNAL_MEMBERS.equals(elementLocalName)) {
            List<Long> externalMemberIds = this.externalGroupMemberMapper.importListXml(inputCursor);
            Set<String> externalMembers = this.importedUsers.findAllExternalUsers(externalMemberIds);
            this.localGroupMemberships.put(this.groupName, externalMembers);
        }
    }

    private void ensureInternalDirectoryGroupExists() throws DirectoryNotFoundException, InvalidGroupException {
        if (!this.isGroupCreated) {
            this.groupDao.add((Group)new GroupTemplate(this.groupName, ((Directory)this.internalDirectory.get()).getId().longValue(), GroupType.GROUP));
            this.isGroupCreated = true;
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<DefaultHibernateGroup> externalEntities, @NotNull DefaultHibernateGroup object, long objectIndex, @NotNull Session session) throws Exception {
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        super.importListXml(inputCursor);
        Path path = LocalGroupMapper.getMembershipDataPath(this.bootstrapManager);
        String json = new Gson().toJson(this.localGroupMemberships);
        BambooPathUtils.writeStringToFile((Path)path, (String)json, (Charset)StandardCharsets.UTF_8);
        this.localGroupMemberships.clear();
        this.internalDirectory.reset();
        this.groupName = null;
    }

    public static Path getMembershipDataPath(BootstrapManager bootstrapManager) {
        return Paths.get(bootstrapManager.getConfigDirectory(), LocalGroupMapper.class.getSimpleName() + ".json");
    }

    private static class GroupMemberMapper
    extends BambooStAXMappingListHelperAbstractImpl<Long, Long> {
        private final String rootNode;

        public GroupMemberMapper(SessionFactory sessionFactory, String rootNode, @NotNull TransactionOperations transactionOperations) {
            super(sessionFactory, transactionOperations);
            this.rootNode = rootNode;
        }

        @Override
        @NotNull
        public String getXmlRootNodeName() {
            return this.rootNode;
        }

        @Override
        @NotNull
        public String getXmlElementNodeName() {
            return LocalGroupMapper.XML_MEMBER;
        }

        @Override
        @NotNull
        protected Long createItemInstance(SMInputCursor inputCursor) throws Exception {
            return inputCursor.getElemLongValue();
        }

        @Override
        protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull Long object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
            outputElement.addValue(object.longValue());
        }
    }
}

