/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.userdata;

import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.userdata.ImportedUsers;
import com.atlassian.bamboo.utils.BambooSuppliers;
import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.util.UserUtils;
import com.atlassian.user.impl.hibernate3.DefaultHibernateUser;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

public class LocalUserMapper
extends BambooStAXMappingListHelperAbstractImpl<DefaultHibernateUser, DefaultHibernateUser>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(LocalUserMapper.class);
    private static final String XML_ROOT = "localUsers";
    private static final String XML_NODE = "localUser";
    private static final String XML_ID = "id";
    private static final String XML_NAME = "name";
    private static final String XML_PASSWORD = "password";
    private static final String XML_FULL_NAME = "fullName";
    private static final String XML_EMAIL = "email";
    private static final String XML_ENABLED = "enabled";
    @Inject
    private ImportedUsers importedUsers;
    @Inject
    private UserDao userDao;
    @Inject
    private CrowdDirectoryService crowdDirectoryService;
    private final BambooSuppliers.ResettableMemoizingSupplier<Directory> internalDirectory = BambooSuppliers.memoizeResettably(() -> LocalUserMapper.getInternalDirectory(this.crowdDirectoryService));

    public LocalUserMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
    }

    @Override
    @NotNull
    protected DefaultHibernateUser createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new DefaultHibernateUser();
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull DefaultHibernateUser object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        new SMOutputElementAppender(outputElement).append(XML_ID, object.getId()).append(XML_NAME, object.getName()).appendIfNotBlank(XML_PASSWORD, object.getPassword()).appendIfNotBlank(XML_FULL_NAME, object.getFullName()).appendIfNotBlank(XML_EMAIL, object.getEmail()).appendIfNotBlank(XML_ENABLED, Boolean.toString(object.isEnabled()));
    }

    @Override
    protected void importProperties(@NotNull DefaultHibernateUser object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        if (XML_ID.equals(elementLocalName)) {
            object.setId(inputCursor.getElemLongValue());
        } else if (XML_NAME.equals(elementLocalName)) {
            object.setName(inputCursor.getElemStringValue());
        } else if (XML_FULL_NAME.equals(elementLocalName)) {
            object.setFullName(inputCursor.getElemStringValue());
        } else if (XML_EMAIL.equals(elementLocalName)) {
            object.setEmail(inputCursor.getElemStringValue());
        } else if (XML_PASSWORD.equals(elementLocalName)) {
            object.setPassword(inputCursor.getElemStringValue());
        } else if (XML_ENABLED.equals(elementLocalName)) {
            object.setEnabled(inputCursor.getElemBooleanValue(true));
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<DefaultHibernateUser> externalEntities, @NotNull DefaultHibernateUser hibernateUser, long objectIndex, @NotNull Session session) throws Exception {
        UserTemplate userWithoutNames = new UserTemplate(hibernateUser.getName(), ((Directory)this.internalDirectory.get()).getId().longValue());
        userWithoutNames.setActive(hibernateUser.isEnabled());
        userWithoutNames.setEmailAddress(hibernateUser.getEmail());
        userWithoutNames.setDisplayName(StringUtils.defaultString((String)hibernateUser.getFullName(), (String)"-"));
        User userWithNames = UserUtils.populateNames((User)userWithoutNames);
        log.debug((Object)("Copying user: " + userWithoutNames.getName()));
        this.userDao.add(userWithNames, PasswordCredential.encrypted((String)StringUtils.defaultString((String)hibernateUser.getPassword())));
        this.importedUsers.remember(hibernateUser);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        super.importListXml(inputCursor);
        this.internalDirectory.reset();
    }

    @Nullable
    static Directory getInternalDirectory(CrowdDirectoryService crowdDirectoryService) {
        for (Directory directory : crowdDirectoryService.findAllDirectories()) {
            if (!directory.getImplementationClass().equals(InternalDirectory.class.getCanonicalName())) continue;
            return directory;
        }
        return null;
    }
}

