/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.userdata;

import bucket.user.propertyset.BucketPropertySetItem;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.dao.PropertyEntryExportDao;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class PropertyEntryMapper
extends BambooStAXMappingListHelperAbstractImpl<BucketPropertySetItem, BucketPropertySetItem>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(PropertyEntryMapper.class);
    private static final String XML_ROOT = "propertyEntries";
    private static final String XML_NODE = "propertyEntry";
    private static final String XML_ENTITY_NAME = "entityName";
    private static final String XML_ENTITY_ID = "entityId";
    private static final String XML_ENTITY_KEY = "entityKey";
    private static final String XML_KEY_TYPE = "keyType";
    private static final String XML_BOOLEAN_VALUE = "booleanValue";
    private static final String XML_DOUBLE_VALUE = "doubleValue";
    private static final String XML_STRING_VALUE = "stringValue";
    private static final String XML_TEXT_VALUE = "textValue";
    private static final String XML_LONG_VALUE = "longValue";
    private static final String XML_INT_VALUE = "intValue";
    private static final String XML_DATE_VALUE = "dateValue";
    private final PropertyEntryExportDao propertyEntryExportDao;

    public PropertyEntryMapper(SessionFactory sessionFactory, PropertyEntryExportDao propertyEntryExportDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.propertyEntryExportDao = propertyEntryExportDao;
    }

    @Override
    @NotNull
    protected BucketPropertySetItem createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new BucketPropertySetItem();
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull BucketPropertySetItem object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElementAppender appender = new SMOutputElementAppender(outputElement).append(XML_ENTITY_NAME, object.getEntityName()).append(XML_ENTITY_ID, object.getEntityId()).append(XML_ENTITY_KEY, object.getKey()).append(XML_KEY_TYPE, object.getType()).append(XML_DOUBLE_VALUE, Double.toString(object.getDoubleVal())).appendCData(XML_STRING_VALUE, object.getStringVal()).appendCData(XML_TEXT_VALUE, object.getTextVal()).append(XML_LONG_VALUE, object.getLongVal()).append(XML_INT_VALUE, object.getIntVal()).append(XML_BOOLEAN_VALUE, object.getBooleanVal()).appendIfNotNull(XML_DATE_VALUE, object.getDateVal());
    }

    @Override
    protected void importProperties(@NotNull BucketPropertySetItem object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        if (XML_ENTITY_NAME.equals(elementLocalName)) {
            object.setEntityName(inputCursor.getElemStringValue());
        } else if (XML_ENTITY_ID.equals(elementLocalName)) {
            object.setEntityId(inputCursor.getElemLongValue());
        } else if (XML_ENTITY_KEY.equals(elementLocalName)) {
            object.setKey(inputCursor.getElemStringValue());
        } else if (XML_KEY_TYPE.equals(elementLocalName)) {
            object.setType(inputCursor.getElemIntValue());
        } else if (XML_DOUBLE_VALUE.equals(elementLocalName)) {
            object.setDoubleVal(inputCursor.getElemDoubleValue());
        } else if (XML_STRING_VALUE.equals(elementLocalName)) {
            object.setStringVal(inputCursor.getElemStringValue());
        } else if (XML_TEXT_VALUE.equals(elementLocalName)) {
            object.setTextVal(inputCursor.getElemStringValue());
        } else if (XML_LONG_VALUE.equals(elementLocalName)) {
            object.setLongVal(inputCursor.getElemLongValue());
        } else if (XML_INT_VALUE.equals(elementLocalName)) {
            object.setIntVal(inputCursor.getElemIntValue());
        } else if (XML_BOOLEAN_VALUE.equals(elementLocalName)) {
            object.setBooleanVal(inputCursor.getElemBooleanValue());
        } else if (XML_DATE_VALUE.equals(elementLocalName)) {
            object.setDateVal(MapperUtil.parseDateElement(inputCursor.getElemStringValue()));
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<BucketPropertySetItem> externalEntities, @NotNull BucketPropertySetItem object, long objectIndex, @NotNull Session session) throws Exception {
        this.propertyEntryExportDao.save(object);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportListXml(outputElement, this.propertyEntryExportDao.findAll(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        super.importListXml(inputCursor);
    }
}

