/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.variable.baseline;

import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.bamboo.variable.baseline.VariableBaselineItem;
import com.atlassian.bamboo.variable.baseline.VariableBaselineItemImpl;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="variableBaselineItems", itemNodeName="item")
public class VariableBaselineItemMapper
extends BambooStAXMappingListHelperAbstractImpl<VariableBaselineItem, VariableBaselineItem> {
    private static final Logger log = Logger.getLogger(VariableBaselineItemMapper.class);
    private static final String ITEM_KEY = "key";
    private static final String ITEM_VALUE = "value";
    private static final String ITEM_VARIABLE_TYPE = "variableType";

    public VariableBaselineItemMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
    }

    @Override
    @NotNull
    protected VariableBaselineItem createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new VariableBaselineItemImpl();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull VariableBaselineItem baselineItem, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, baselineItem, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(ITEM_KEY, baselineItem.getKey()).appendIfNotBlank(ITEM_VALUE, baselineItem.getValue()).append(ITEM_VARIABLE_TYPE, (Enum)baselineItem.getVariableType());
    }

    @Override
    protected void importProperties(@NotNull VariableBaselineItem baselineItem, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(baselineItem, inputCursor, session);
        String elementName = inputCursor.getLocalName();
        if (ITEM_KEY.equals(elementName)) {
            baselineItem.setKey(inputCursor.getElemStringValue());
        } else if (ITEM_VALUE.equals(elementName)) {
            baselineItem.setValue(inputCursor.getElemStringValue());
        } else if (ITEM_VARIABLE_TYPE.equals(elementName)) {
            baselineItem.setVariableType(VariableType.valueOf((String)inputCursor.getElemStringValue()));
        }
    }
}

