/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.variable.baseline;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ImportContext;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.stream.variable.baseline.VariableBaselineItemMapper;
import com.atlassian.bamboo.migration.stream.variable.baseline.VariableContextBaselinePropertiesMapper;
import com.atlassian.bamboo.variable.baseline.VariableBaselineItem;
import com.atlassian.bamboo.variable.baseline.VariableContextBaseline;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineDao;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineImpl;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="variableContextBaselines", itemNodeName="baseline")
public class VariableContextBaselineMapper
extends BambooStAXMappingListHelperAbstractImpl<VariableContextBaseline, VariableContextBaseline>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(VariableContextBaselineMapper.class);
    private final ImportContext<VariableContextBaseline> variableContextBaselineImportContext = ImportContext.create("variableContextBaseline");
    private final VariableBaselineItemMapper variableBaselineItemMapper;
    private final VariableContextBaselineDao variableContextBaselineDao;
    private final VariableContextBaselinePropertiesMapper variableContextBaselinePropertiesMapper;

    public VariableContextBaselineMapper(SessionFactory sessionFactory, VariableBaselineItemMapper variableBaselineItemMapper, VariableContextBaselineDao variableContextBaselineDao, VariableContextBaselinePropertiesMapper variableContextBaselinePropertiesMapper, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.variableBaselineItemMapper = variableBaselineItemMapper;
        this.variableContextBaselineDao = variableContextBaselineDao;
        this.variableContextBaselinePropertiesMapper = variableContextBaselinePropertiesMapper;
    }

    @Override
    public boolean isShouldExport(@NotNull ExportDetailsBean exportDetailsBean) {
        return exportDetailsBean.isExportResults();
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<VariableContextBaseline> list, @NotNull VariableContextBaseline object, long objectIndex, @NotNull Session session) throws Exception {
        this.variableContextBaselineImportContext.clear();
    }

    @Override
    @NotNull
    protected VariableContextBaseline createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new VariableContextBaselineImpl();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull VariableContextBaseline baseline, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        this.variableContextBaselinePropertiesMapper.exportXml(session, outputElement, baseline, exportDetailsBean);
        this.variableBaselineItemMapper.exportListXml(session, outputElement, baseline.getVariables(), exportDetailsBean);
    }

    @Override
    protected void importProperties(@NotNull VariableContextBaseline foobar, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementName = inputCursor.getLocalName();
        if (MapperUtil.matchesElement(this.variableContextBaselinePropertiesMapper, elementName)) {
            VariableContextBaseline baseline = (VariableContextBaseline)this.variableContextBaselinePropertiesMapper.importXml(session, inputCursor);
            this.saveBambooObject(session, (BambooIdProvider)baseline);
            this.variableContextBaselineImportContext.set(baseline);
        } else if (MapperUtil.matchesElement(this.variableBaselineItemMapper, elementName)) {
            List baselineItemList = this.variableBaselineItemMapper.importListXml(session, inputCursor);
            for (VariableBaselineItem baselineItem : baselineItemList) {
                baselineItem.setOwningBaseline(this.variableContextBaselineImportContext.get());
                this.saveBambooObject(session, (BambooIdProvider)baselineItem);
            }
        }
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.variableContextBaselineDao.iterateVariableContextBaselinesForExport(MapperUtil.exportXmlFunction(this, rootElement, exportDetailsBean));
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.clear();
    }
}

