/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream.variable.baseline;

import com.atlassian.bamboo.migration.BambooStAXMappingHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ItemMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.variable.baseline.VariableContextBaseline;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineImpl;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineImportHelper;
import com.google.common.base.Preconditions;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ItemMapper(rootNodeName="properties")
public class VariableContextBaselinePropertiesMapper
extends BambooStAXMappingHelperAbstractImpl<VariableContextBaseline, VariableContextBaseline> {
    private static final Logger log = Logger.getLogger(VariableContextBaselinePropertiesMapper.class);
    private final String BASELINE_HASH = "hash";

    public VariableContextBaselinePropertiesMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
    }

    @Override
    @NotNull
    protected VariableContextBaseline createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new VariableContextBaselineImpl();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull VariableContextBaseline object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        VariableContextBaselineImpl baseline = (VariableContextBaselineImpl)Narrow.downTo((Object)object, VariableContextBaselineImpl.class);
        Preconditions.checkArgument((baseline != null ? 1 : 0) != 0, (Object)"Bad class of VariableContextBaseline object");
        assert (baseline != null);
        super.exportProperties(outputElement, baseline, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append("hash", baseline.getHash());
    }

    @Override
    protected void importProperties(@NotNull VariableContextBaseline object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        VariableContextBaselineImpl baseline = (VariableContextBaselineImpl)Narrow.downTo((Object)object, VariableContextBaselineImpl.class);
        Preconditions.checkArgument((baseline != null ? 1 : 0) != 0, (Object)"Bad class of VariableContextBaseline object");
        assert (baseline != null);
        super.importProperties(baseline, inputCursor, session);
        String elementName = inputCursor.getLocalName();
        if ("hash".equals(elementName)) {
            VariableContextBaselineImportHelper.setHash(baseline, inputCursor.getElemStringValue());
        }
    }
}

