/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.utils;

import com.atlassian.bamboo.persistence.ImportAwareGenerator;
import com.atlassian.bamboo.persistence.ResettableTableHiLoGenerator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.jdbc.Work;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class BambooResetableHiLoGeneratorHelper {
    private static final Logger log = Logger.getLogger(BambooResetableHiLoGeneratorHelper.class);
    public static final String HIBERNATE_UNIQUE_KEY_COLUMN = "next_hi";
    public static final String HIBERNATE_UNIQUE_KEY_TABLE = "hibernate_unique_key";
    @Autowired
    private SessionFactory sessionFactory;

    public void setNextHiValue(final List<String> errors) {
        Session session = this.sessionFactory.getCurrentSession();
        TransactionCoordinator transactionCoordinatorBuilder = (TransactionCoordinator)((SessionImplementor)session).getTransactionCoordinator().createIsolationDelegate().delegateWork((WorkExecutorVisitable)new WorkExecutorVisitable<TransactionCoordinator>(){
            private final NextHiSetter nextHiSetter;
            {
                this.nextHiSetter = new NextHiSetter(errors, BambooResetableHiLoGeneratorHelper.this.sessionFactory);
            }

            public TransactionCoordinator accept(WorkExecutor<TransactionCoordinator> executor, Connection connection) throws SQLException {
                executor.executeWork((Work)this.nextHiSetter, connection);
                return null;
            }
        }, true);
    }

    public void resetGenerators() {
        MetamodelImplementor metamodel = ((SessionFactoryImplementor)this.sessionFactory).getMetamodel();
        for (String entityName : metamodel.getAllEntityNames()) {
            EntityPersister persister = metamodel.entityPersister(entityName);
            ResettableTableHiLoGenerator generator = BambooResetableHiLoGeneratorHelper.getResettableGenerator(persister);
            if (generator == null) continue;
            generator.reset();
        }
    }

    @Nullable
    private static ResettableTableHiLoGenerator getResettableGenerator(EntityPersister persister) {
        if (persister instanceof SingleTableEntityPersister && persister.getIdentifierGenerator() instanceof ImportAwareGenerator) {
            return ((ImportAwareGenerator)persister.getIdentifierGenerator()).getResettableGenerator();
        }
        return null;
    }

    private static class NextHiSetter
    implements Work {
        private final List<String> errors;
        private final SessionFactoryImplementor sessionFactory;

        private NextHiSetter(List<String> errors, SessionFactory sessionFactory) {
            this.errors = errors;
            this.sessionFactory = (SessionFactoryImplementor)sessionFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Connection connection) {
            try (Statement statement = connection.createStatement();){
                long maximumId = 0L;
                int maxLo = 0;
                for (String entityName : this.sessionFactory.getMetamodel().getAllEntityNames()) {
                    EntityPersister persister = this.sessionFactory.getMetamodel().entityPersister(entityName);
                    ResettableTableHiLoGenerator generator = BambooResetableHiLoGeneratorHelper.getResettableGenerator(persister);
                    if (generator == null) continue;
                    if (maxLo == 0) {
                        maxLo = generator.getMaxLo();
                    } else if (maxLo != generator.getMaxLo()) {
                        this.errors.add("One generator uses " + maxLo + " for maxLo, generator for " + entityName + " uses " + generator.getMaxLo());
                    }
                    SingleTableEntityPersister entityPersister = (SingleTableEntityPersister)persister;
                    String[] idColumnNames = entityPersister.getIdentifierColumnNames();
                    if (idColumnNames.length != 1) {
                        this.errors.add("Expected a single ID column for " + entityName + " found " + idColumnNames.length);
                    }
                    String sql = "select max(" + idColumnNames[0] + ") from " + entityPersister.getTableName();
                    try (ResultSet resultSet = statement.executeQuery(sql);){
                        if (resultSet.next()) {
                            long value = resultSet.getLong(1);
                            if (value <= maximumId) continue;
                            maximumId = value;
                            continue;
                        }
                        this.errors.add("No maximum ID returned for " + entityName);
                    }
                }
                this.setNextHi(statement, (int)(maximumId / (long)(maxLo + 1)) + 1);
            }
            catch (Exception e) {
                log.error((Object)"Error finding maximum next_hi value", (Throwable)e);
                this.errors.add(e.getMessage());
            }
            finally {
                log.info((Object)"Completed database update: HiLoIdRepairUpgradeTask");
            }
        }

        private void setNextHi(Statement statement, int nextHi) throws SQLException {
            log.info((Object)("Setting new next_hi to " + nextHi));
            if (statement.executeUpdate("update hibernate_unique_key set next_hi = " + nextHi) == 0 && statement.executeUpdate("insert into hibernate_unique_key values(" + nextHi + ")") == 0) {
                this.errors.add("failed to insert initial next_hi value");
            }
        }
    }
}

