/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseDao;
import com.atlassian.bamboo.resultsummary.tests.TestCaseImpl;
import com.atlassian.bamboo.resultsummary.tests.TestClass;
import com.atlassian.bamboo.resultsummary.tests.TestClassImpl;
import com.atlassian.core.bean.EntityObject;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

public class TestCaseMapper
extends BambooStAXMappingListHelperAbstractImpl<TestCase, TestCase>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(TestCaseMapper.class);
    static final String XML_ROOT = "testCases";
    static final String XML_NODE = "testCase";
    static final String XML_TEST_CLASS_ID = "testClassId";
    static final String XML_NAME = "name";
    static final String XML_NUMBER_OF_SUCCESSFUL_RUNS = "numOfSuccessfulRuns";
    static final String XML_NUMBER_OF_FAILED_RUNS = "numOfFailedRuns";
    static final String XML_AVERAGE_DURATION = "avgDuration";
    static final String XML_FIRST_RAN_BUILD_NUMBER = "firstRanBuildNo";
    static final String XML_LAST_RAN_BUILD_NUMBER = "lastRanBuildNo";
    static final String XML_LAST_RECORDED_BUILD_NUMBER = "lastRecordedBuildNo";
    static final String XML_QUARANTINE_USERNAME = "quarantiningUsername";
    static final String XML_QUARANTINE_DATE = "quarantineDate";
    static final String XML_QUARANTINE_EXPIRY_DATE = "quarantineExpiryDate";
    static final String XML_LINKED_JIRA_ISSUE_KEY = "issueKey";
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private String currentTestCaseUserName = null;
    private Date currentTestCaseDate = null;
    private Date currentTestCaseExpiryDate = null;
    private final TestCaseDao testCaseDao;

    public TestCaseMapper(SessionFactory sessionFactory, TestCaseDao testCaseDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.testCaseDao = testCaseDao;
    }

    @Override
    @NotNull
    protected TestCaseImpl createItemInstance(@NotNull SMInputCursor inputCursor) throws Exception {
        return new TestCaseImpl();
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    protected void importProperties(@NotNull TestCase object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        if (object instanceof TestCaseImpl) {
            TestCaseImpl testCase = (TestCaseImpl)object;
            String elementLocalName = inputCursor.getLocalName();
            super.importProperties(testCase, inputCursor, session);
            if (XML_TEST_CLASS_ID.equals(elementLocalName)) {
                TestClassImpl testClass = new TestClassImpl();
                testClass.setId(inputCursor.getElemLongValue());
                testCase.setTestClass((TestClass)testClass);
            } else if (XML_NAME.equals(elementLocalName)) {
                testCase.setNameAndTruncate(inputCursor.getElemStringValue());
            } else if (XML_NUMBER_OF_SUCCESSFUL_RUNS.equals(elementLocalName)) {
                testCase.setNumberOfSuccessRuns(inputCursor.getElemIntValue(0));
            } else if (XML_NUMBER_OF_FAILED_RUNS.equals(elementLocalName)) {
                testCase.setNumberOfFailedRuns(inputCursor.getElemIntValue(0));
            } else if (XML_AVERAGE_DURATION.equals(elementLocalName)) {
                testCase.setAverageDuration(inputCursor.getElemLongValue(0L));
            } else if (XML_FIRST_RAN_BUILD_NUMBER.equals(elementLocalName)) {
                testCase.setFirstRanBuildNumber(inputCursor.getElemIntValue(-1));
            } else if (XML_LAST_RAN_BUILD_NUMBER.equals(elementLocalName)) {
                testCase.setLastRanBuildNumber(inputCursor.getElemIntValue(-1));
            } else if (XML_LAST_RECORDED_BUILD_NUMBER.equals(elementLocalName)) {
                testCase.setLastRecordedBuildNumber(inputCursor.getElemIntValue(-1));
            } else if (XML_LINKED_JIRA_ISSUE_KEY.equals(elementLocalName)) {
                testCase.setLinkedJiraIssueKey(inputCursor.getElemStringValue());
            } else if (XML_QUARANTINE_USERNAME.equals(elementLocalName)) {
                this.currentTestCaseUserName = inputCursor.getElemStringValue();
            } else if (XML_QUARANTINE_DATE.equals(elementLocalName)) {
                this.currentTestCaseDate = MapperUtil.parseDateElement(inputCursor.getElemStringValue());
            } else if (XML_QUARANTINE_EXPIRY_DATE.equals(elementLocalName)) {
                this.currentTestCaseExpiryDate = MapperUtil.parseDateElement(inputCursor.getElemStringValue());
            }
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull TestCase testCase, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, testCase, session, exportDetailsBean);
        SMOutputElementAppender appender = new SMOutputElementAppender(outputElement);
        appender.append(XML_TEST_CLASS_ID, (EntityObject)testCase.getTestClass()).append(XML_NAME, testCase.getName()).append(XML_NUMBER_OF_SUCCESSFUL_RUNS, testCase.getNumberOfSuccessRuns()).append(XML_NUMBER_OF_FAILED_RUNS, testCase.getNumberOfFailedRuns()).append(XML_AVERAGE_DURATION, testCase.getAverageDuration()).append(XML_FIRST_RAN_BUILD_NUMBER, testCase.getFirstRanBuildNumber()).append(XML_LAST_RAN_BUILD_NUMBER, testCase.getLastRanBuildNumber()).append(XML_LAST_RECORDED_BUILD_NUMBER, testCase.getLastRecordedBuildNumber()).appendIfNotBlank(XML_LINKED_JIRA_ISSUE_KEY, testCase.getLinkedJiraIssueKey());
        if (testCase.getQuarantineStatistics() != null) {
            appender.append(XML_QUARANTINE_USERNAME, testCase.getQuarantineStatistics().getQuarantiningUsername()).appendIfNotNull(XML_QUARANTINE_DATE, testCase.getQuarantineStatistics().getQuarantineDate(), UTC_TIMEZONE).appendIfNotNull(XML_QUARANTINE_EXPIRY_DATE, testCase.getQuarantineStatistics().getQuarantineExpiryDate(), UTC_TIMEZONE);
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<TestCase> list, @NotNull TestCase object, long objectIndex, @NotNull Session session) throws Exception {
        if (this.currentTestCaseDate != null && this.currentTestCaseUserName != null) {
            object.setQuarantineStatistics(this.currentTestCaseUserName, this.currentTestCaseDate, this.currentTestCaseExpiryDate);
        }
        this.currentTestCaseDate = null;
        this.currentTestCaseExpiryDate = null;
        this.currentTestCaseUserName = null;
        this.eventEndElementOfListItemSaveObject(session, object, objectIndex, 50L);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, final ExportDetailsBean exportDetailsBean) throws Exception {
        final SMOutputElement rootElement = this.createListRootElement(outputElement);
        final long testCasesCount = this.testCaseDao.countTestCases();
        this.testCaseDao.scrollTestCasesForExport((Consumer)new Consumer<TestCase>(){
            private long index = 0L;

            @Override
            public void accept(@Nullable TestCase testCase) {
                if (testCase != null) {
                    try {
                        TestCaseMapper.this.exportXml(rootElement, testCase, exportDetailsBean);
                        ++this.index;
                        if (this.index % 100000L == 0L || this.index == testCasesCount) {
                            log.info((Object)String.format("Exporting TestCases: %d / %d", this.index, testCasesCount));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not export " + testCase), (Throwable)e);
                        throw new MapperExportException(e);
                    }
                }
            }
        });
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        this.currentTestCaseDate = null;
        this.currentTestCaseExpiryDate = null;
        this.currentTestCaseUserName = null;
        session.clear();
    }
}

