/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultDao;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultErrorImpl;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultImpl;
import com.atlassian.core.bean.EntityObject;
import java.util.List;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

public class TestCaseResultErrorMapper
extends BambooStAXMappingListHelperAbstractImpl<TestCaseResultError, TestCaseResultError>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(TestCaseResultErrorMapper.class);
    static final String XML_ROOT = "testCaseResultErrors";
    static final String XML_NODE = "error";
    static final String XML_TEST_CASE_RESULT_ID = "tcrId";
    static final String XML_CONTENT = "content";
    private final TestCaseResultDao testCaseResultDao;

    public TestCaseResultErrorMapper(SessionFactory sessionFactory, TestCaseResultDao testCaseResultDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.testCaseResultDao = testCaseResultDao;
    }

    @Override
    public boolean isShouldExport(@NotNull ExportDetailsBean exportDetailsBean) {
        return exportDetailsBean.isExportResults();
    }

    @Override
    @NotNull
    protected TestCaseResultErrorImpl createItemInstance(@NotNull SMInputCursor inputCursor) throws Exception {
        return new TestCaseResultErrorImpl();
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    protected void importProperties(@NotNull TestCaseResultError object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        if (object instanceof TestCaseResultErrorImpl) {
            TestCaseResultErrorImpl testCaseResultError = (TestCaseResultErrorImpl)object;
            String elementLocalName = inputCursor.getLocalName();
            if (XML_TEST_CASE_RESULT_ID.equals(elementLocalName)) {
                TestCaseResultImpl testCaseResult = new TestCaseResultImpl();
                testCaseResult.setId(inputCursor.getElemLongValue());
                testCaseResultError.setTestCaseResult((TestCaseResult)testCaseResult);
            } else if (XML_CONTENT.equals(elementLocalName)) {
                testCaseResultError.setContent(inputCursor.getElemStringValue());
            }
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull TestCaseResultError object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(XML_TEST_CASE_RESULT_ID, (EntityObject)object.getTestCaseResult()).appendCData(XML_CONTENT, object.getContent());
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<TestCaseResultError> list, @NotNull TestCaseResultError object, long objectIndex, @NotNull Session session) throws Exception {
        this.eventEndElementOfListItemSaveObject(session, object, objectIndex, 50L);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, final ExportDetailsBean exportDetailsBean) throws Exception {
        final SMOutputElement rootElement = this.createListRootElement(outputElement);
        final long testCaseResultErrorsCount = this.testCaseResultDao.countTestCaseResultErrors();
        this.testCaseResultDao.scrollTestCaseResultErrorsForExport((Consumer)new Consumer<TestCaseResultError>(){
            private long index = 0L;

            @Override
            public void accept(@Nullable TestCaseResultError testCaseResultError) {
                if (testCaseResultError != null) {
                    try {
                        TestCaseResultErrorMapper.this.exportXml(rootElement, testCaseResultError, exportDetailsBean);
                        ++this.index;
                        if (this.index % 100000L == 0L || this.index == testCaseResultErrorsCount) {
                            log.info((Object)String.format("Exporting TestCaseResultErrors: %d / %d", this.index, testCaseResultErrorsCount));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not export " + testCaseResultError), (Throwable)e);
                        throw new MapperExportException(e);
                    }
                }
            }
        });
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.clear();
    }
}

