/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseImpl;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultDao;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultImpl;
import com.atlassian.bamboo.resultsummary.tests.TestClassResult;
import com.atlassian.bamboo.resultsummary.tests.TestClassResultImpl;
import com.atlassian.bamboo.resultsummary.tests.TestDeltaState;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.core.bean.EntityObject;
import java.util.List;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

public class TestCaseResultMapper
extends BambooStAXMappingListHelperAbstractImpl<TestCaseResult, TestCaseResult>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(TestCaseResultMapper.class);
    static final String XML_ROOT = "testCaseResults";
    static final String XML_NODE = "result";
    static final String XML_TEST_CASE_ID = "tcId";
    static final String XML_TEST_CLASS_RESULT_ID = "tcrId";
    static final String XML_DURATION = "d";
    static final String XML_STATE = "s";
    static final String XML_DELTA_STATE = "ds";
    static final String XML_FAILING_SINCE = "fs";
    static final String XML_QUARANTINED = "q";
    private final TestCaseResultDao testCaseResultDao;

    public TestCaseResultMapper(SessionFactory sessionFactory, TestCaseResultDao testCaseResultDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.testCaseResultDao = testCaseResultDao;
    }

    @Override
    public boolean isShouldExport(@NotNull ExportDetailsBean exportDetailsBean) {
        return exportDetailsBean.isExportResults();
    }

    @Override
    @NotNull
    protected TestCaseResultImpl createItemInstance(@NotNull SMInputCursor inputCursor) throws Exception {
        return new TestCaseResultImpl();
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    protected void importProperties(@NotNull TestCaseResult object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        if (object instanceof TestCaseResultImpl) {
            TestCaseResultImpl testCaseResult = (TestCaseResultImpl)object;
            String elementLocalName = inputCursor.getLocalName();
            if (XML_TEST_CASE_ID.equals(elementLocalName)) {
                TestCaseImpl testCase = new TestCaseImpl();
                testCase.setId(inputCursor.getElemLongValue());
                testCaseResult.setTestCase((TestCase)testCase);
            } else if (XML_TEST_CLASS_RESULT_ID.equals(elementLocalName)) {
                TestClassResultImpl testClassResult = new TestClassResultImpl();
                testClassResult.setId(inputCursor.getElemLongValue());
                testCaseResult.setTestClassResult((TestClassResult)testClassResult);
            } else if (XML_DURATION.equals(elementLocalName)) {
                testCaseResult.setDuration(inputCursor.getElemLongValue());
            } else if (XML_STATE.equals(elementLocalName)) {
                testCaseResult.setState((TestState)inputCursor.getElemEnumValue(TestState.class));
            } else if (XML_DELTA_STATE.equals(elementLocalName)) {
                testCaseResult.setDeltaState((TestDeltaState)inputCursor.getElemEnumValue(TestDeltaState.class));
            } else if (XML_FAILING_SINCE.equals(elementLocalName)) {
                testCaseResult.setFailingSince(inputCursor.getElemIntValue());
            } else if (XML_QUARANTINED.equals(elementLocalName)) {
                testCaseResult.setQuarantined(inputCursor.getElemBooleanValue());
            }
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull TestCaseResult object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(XML_TEST_CASE_ID, (EntityObject)object.getTestCase()).append(XML_TEST_CLASS_RESULT_ID, (EntityObject)object.getTestClassResult()).append(XML_DURATION, object.getDuration()).appendIfNotNull(XML_STATE, object.getState()).appendIfNotNull(XML_DELTA_STATE, object.getDeltaState()).append(XML_FAILING_SINCE, object.getFailingSince()).append(XML_QUARANTINED, object.isQuarantined());
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<TestCaseResult> list, @NotNull TestCaseResult object, long objectIndex, @NotNull Session session) throws Exception {
        this.eventEndElementOfListItemSaveObject(session, object, objectIndex, 50L);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, final ExportDetailsBean exportDetailsBean) throws Exception {
        final SMOutputElement rootElement = this.createListRootElement(outputElement);
        final long testCaseResultsCount = this.testCaseResultDao.countTestCaseResults();
        this.testCaseResultDao.scrollTestCaseResultsForExport((Consumer)new Consumer<TestCaseResult>(){
            private long index = 0L;

            @Override
            public void accept(@Nullable TestCaseResult testCaseResult) {
                if (testCaseResult != null) {
                    try {
                        TestCaseResultMapper.this.exportXml(rootElement, testCaseResult, exportDetailsBean);
                        ++this.index;
                        if (this.index % 100000L == 0L || this.index == testCaseResultsCount) {
                            log.info((Object)String.format("Exporting TestCaseResults: %d / %d", this.index, testCaseResultsCount));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not export " + testCaseResult), (Throwable)e);
                        throw new MapperExportException(e);
                    }
                }
            }
        });
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.clear();
    }
}

