/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.resultsummary.tests.TestClass;
import com.atlassian.bamboo.resultsummary.tests.TestClassImpl;
import com.atlassian.bamboo.resultsummary.tests.TestsDao;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

public class TestClassMapper
extends BambooStAXMappingListHelperAbstractImpl<TestClass, TestClass>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(TestClassMapper.class);
    static final String XML_ROOT = "testClasses";
    static final String XML_NODE = "testClass";
    static final String XML_NAME = "name";
    static final String XML_PLAN = "plan";
    static final String XML_MASTER_JOB_ID = "masterJobId";
    private Map<String, Plan> planMap = new HashMap<String, Plan>();
    private final PlanDao planDao;
    private final TestsDao testsDao;

    public TestClassMapper(SessionFactory sessionFactory, PlanDao planDao, TestsDao testsDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.planDao = planDao;
        this.testsDao = testsDao;
    }

    @Override
    @NotNull
    protected TestClassImpl createItemInstance(@NotNull SMInputCursor inputCursor) throws Exception {
        return new TestClassImpl();
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor cursor, @NotNull List<TestClass> list, @NotNull TestClass object, long objectIndex, @NotNull Session session) throws Exception {
        this.eventEndElementOfListItemSaveObject(session, object, objectIndex, 50L);
    }

    @Override
    protected void importProperties(@NotNull TestClass object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        if (object instanceof TestClassImpl) {
            TestClassImpl testClass = (TestClassImpl)object;
            String elementLocalName = inputCursor.getLocalName();
            super.importProperties(object, inputCursor, session);
            if (XML_NAME.equals(elementLocalName)) {
                testClass.setName(inputCursor.getElemStringValue());
            } else if (XML_PLAN.equals(elementLocalName)) {
                testClass.setPlan(this.planMap.get(inputCursor.getElemStringValue()));
            } else if (XML_MASTER_JOB_ID.equals(elementLocalName)) {
                testClass.setMasterJobId(inputCursor.getElemLongValue());
            }
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull TestClass object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(XML_NAME, object.getName()).append(XML_PLAN, object.getPlan().getKey()).append(XML_MASTER_JOB_ID, object.getMasterJobId());
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, final ExportDetailsBean exportDetailsBean) throws Exception {
        final SMOutputElement rootElement = this.createListRootElement(outputElement);
        final long testClassesCount = this.testsDao.countTestClasses();
        this.testsDao.scrollTestClassesForExport((Consumer)new Consumer<TestClass>(){
            private long index = 0L;

            @Override
            public void accept(@Nullable TestClass testClass) {
                if (testClass != null) {
                    try {
                        TestClassMapper.this.exportXml(rootElement, testClass, exportDetailsBean);
                        ++this.index;
                        if (this.index % 100000L == 0L || this.index == testClassesCount) {
                            log.info((Object)String.format("Exporting TestCases: %d / %d", this.index, testClassesCount));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not export " + testClass), (Throwable)e);
                        throw new MapperExportException(e);
                    }
                }
            }
        });
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.initializePlanMap();
        this.importListXml(session, inputCursor);
        session.clear();
    }

    private void initializePlanMap() {
        this.planMap = new HashMap<String, Plan>();
        Collection plans = this.planDao.findAll(Plan.class);
        for (Plan plan : plans) {
            this.planMap.put(plan.getKey(), plan);
        }
    }
}

