/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.tests.TestClass;
import com.atlassian.bamboo.resultsummary.tests.TestClassImpl;
import com.atlassian.bamboo.resultsummary.tests.TestClassResult;
import com.atlassian.bamboo.resultsummary.tests.TestClassResultImpl;
import com.atlassian.bamboo.resultsummary.tests.TestResultsDao;
import com.atlassian.core.bean.EntityObject;
import java.util.List;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

public class TestClassResultMapper
extends BambooStAXMappingListHelperAbstractImpl<TestClassResult, TestClassResult>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(TestClassResultMapper.class);
    static final String XML_ROOT = "testClassResults";
    static final String XML_NODE = "result";
    static final String XML_TEST_CLASS_ID = "tcId";
    static final String XML_BUILD_RESULTS_SUMMARY_ID = "brsId";
    static final String XML_DURATION = "d";
    static final String XML_FAILED_TEST_COUNT = "fTC";
    static final String XML_SUCCESSFUL_TEST_COUNT = "sTC";
    private final TestResultsDao testResultsDao;

    public TestClassResultMapper(SessionFactory sessionFactory, TestResultsDao testResultsDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.testResultsDao = testResultsDao;
    }

    @Override
    public boolean isShouldExport(@NotNull ExportDetailsBean exportDetailsBean) {
        return exportDetailsBean.isExportResults();
    }

    @Override
    @NotNull
    protected TestClassResultImpl createItemInstance(@NotNull SMInputCursor inputCursor) throws Exception {
        return new TestClassResultImpl();
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor cursor, @NotNull List<TestClassResult> list, @NotNull TestClassResult object, long objectIndex, @NotNull Session session) throws Exception {
        this.eventEndElementOfListItemSaveObject(session, object, objectIndex, 50L);
    }

    @Override
    protected void importProperties(@NotNull TestClassResult object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        if (object instanceof TestClassResultImpl) {
            TestClassResultImpl testClassResult = (TestClassResultImpl)object;
            String elementLocalName = inputCursor.getLocalName();
            super.importProperties(testClassResult, inputCursor, session);
            if (XML_TEST_CLASS_ID.equals(elementLocalName)) {
                TestClassImpl testClass = new TestClassImpl();
                testClass.setId(inputCursor.getElemLongValue());
                testClassResult.setTestClass((TestClass)testClass);
            } else if (XML_DURATION.equals(elementLocalName)) {
                testClassResult.setDuration(inputCursor.getElemLongValue());
            } else if (XML_FAILED_TEST_COUNT.equals(elementLocalName)) {
                testClassResult.setFailedTestCount(inputCursor.getElemIntValue());
            } else if (XML_SUCCESSFUL_TEST_COUNT.equals(elementLocalName)) {
                testClassResult.setSuccessfulTestCount(inputCursor.getElemIntValue());
            } else if (XML_BUILD_RESULTS_SUMMARY_ID.equals(elementLocalName)) {
                BuildResultsSummaryImpl buildResultsSummary = new BuildResultsSummaryImpl();
                buildResultsSummary.setId(inputCursor.getElemLongValue());
                testClassResult.setBuildResultsSummary((BuildResultsSummary)buildResultsSummary);
            }
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull TestClassResult object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(XML_TEST_CLASS_ID, (EntityObject)object.getTestClass()).append(XML_BUILD_RESULTS_SUMMARY_ID, (EntityObject)object.getBuildResultsSummary()).append(XML_DURATION, object.getDuration()).append(XML_FAILED_TEST_COUNT, object.getFailedTestCount()).append(XML_SUCCESSFUL_TEST_COUNT, object.getSuccessfulTestCount());
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, final ExportDetailsBean exportDetailsBean) throws Exception {
        final SMOutputElement rootElement = this.createListRootElement(outputElement);
        final long testClassResultsCount = this.testResultsDao.countTestClassResults();
        this.testResultsDao.scrollTestClassResultsForExport((Consumer)new Consumer<TestClassResult>(){
            private long index = 0L;

            @Override
            public void accept(@Nullable TestClassResult testClassResult) {
                if (testClassResult != null) {
                    try {
                        TestClassResultMapper.this.exportXml(rootElement, testClassResult, exportDetailsBean);
                        ++this.index;
                        if (this.index % 100000L == 0L || this.index == testClassResultsCount) {
                            log.info((Object)String.format("Exporting TestClassResults: %d / %d", this.index, testClassResultsCount));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not export " + testClassResult), (Throwable)e);
                        throw new MapperExportException(e);
                    }
                }
            }
        });
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.clear();
    }
}

