/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.warning;

import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummaryDao;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummaryDto;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummaryDtoImpl;
import com.atlassian.bamboo.util.Narrow;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class BuildResultsWarningsSummariesMapper
extends BambooStAXMappingListHelperAbstractImpl<BuildResultWarningSummaryDto, BuildResultWarningSummaryDto>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(BuildResultsWarningsSummariesMapper.class);
    private static final String XML_ROOT = "buildResultsWarningsSummaries";
    private static final String XML_NODE = "warningsSummary";
    private static final String XML_RESULT_SUMMARY_ID = "resultSummaryId";
    private static final String XML_REPOSITORY_ID = "repoId";
    private static final String XML_HIGH_PRIORITY = "high";
    private static final String XML_NORMAL_PRIORITY = "norm";
    private static final String XML_LOW_PRIORITY = "low";
    private final BuildResultWarningSummaryDao buildResultWarningSummaryDao;

    public BuildResultsWarningsSummariesMapper(@NotNull SessionFactory sessionFactory, @NotNull BuildResultWarningSummaryDao buildResultWarningSummaryDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.buildResultWarningSummaryDao = buildResultWarningSummaryDao;
    }

    @Override
    public boolean isShouldExport(@NotNull ExportDetailsBean exportDetailsBean) {
        return exportDetailsBean.isExportResults();
    }

    @Override
    @NotNull
    protected BuildResultWarningSummaryDto createItemInstance(@NotNull SMInputCursor inputCursor) throws Exception {
        return new BuildResultWarningSummaryDtoImpl();
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor cursor, @NotNull List<BuildResultWarningSummaryDto> list, @NotNull BuildResultWarningSummaryDto object, long objectIndex, @NotNull Session session) throws Exception {
        this.eventEndElementOfListItemSaveObject(session, object, objectIndex, 50L);
    }

    @Override
    protected void importProperties(@NotNull BuildResultWarningSummaryDto object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        super.importProperties(object, inputCursor, session);
        BuildResultWarningSummaryDtoImpl entity = (BuildResultWarningSummaryDtoImpl)Narrow.downTo((Object)object, BuildResultWarningSummaryDtoImpl.class);
        if (entity != null) {
            if (XML_RESULT_SUMMARY_ID.equals(elementLocalName)) {
                entity.setResultSummaryId(inputCursor.getElemLongValue());
            } else if (XML_REPOSITORY_ID.equals(elementLocalName)) {
                entity.setRepositoryId(inputCursor.getElemLongValue());
            } else if (XML_HIGH_PRIORITY.equals(elementLocalName)) {
                entity.setHighPriorityCount((long)inputCursor.getElemIntValue());
            } else if (XML_NORMAL_PRIORITY.equals(elementLocalName)) {
                entity.setNormalPriorityCount((long)inputCursor.getElemIntValue());
            } else if (XML_LOW_PRIORITY.equals(elementLocalName)) {
                entity.setLowPriorityCount((long)inputCursor.getElemIntValue());
            }
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull BuildResultWarningSummaryDto object, @NotNull Session session, @NotNull ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        BuildResultWarningSummaryDtoImpl entity = (BuildResultWarningSummaryDtoImpl)Narrow.downTo((Object)object, BuildResultWarningSummaryDtoImpl.class);
        if (entity != null) {
            new SMOutputElementAppender(outputElement).append(XML_RESULT_SUMMARY_ID, entity.getResultSummaryId()).append(XML_REPOSITORY_ID, entity.getRepositoryId()).append(XML_HIGH_PRIORITY, entity.getHighPriorityCount()).append(XML_NORMAL_PRIORITY, entity.getNormalPriorityCount()).append(XML_LOW_PRIORITY, entity.getLowPriorityCount());
        }
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.buildResultWarningSummaryDao.scrollBuildResultWarningsForExport(MapperUtil.exportXmlConsumer(this, rootElement, exportDetailsBean));
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.clear();
    }
}

