/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.security.TrustedKey;
import com.atlassian.bamboo.security.TrustedKeyDao;
import com.atlassian.bamboo.security.TrustedKeyImpl;
import com.atlassian.bamboo.util.Narrow;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="trustedKeys", itemNodeName="trustedKey")
public class TrustedKeyMapper
extends BambooStAXMappingListHelperAbstractImpl<TrustedKey, TrustedKey>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(TrustedKeyMapper.class);
    private final TrustedKeyDao trustedKeyDao;
    private static final String KEY = "key";
    private static final String HOST = "host";
    private static final String APPROVED = "approved";

    public TrustedKeyMapper(SessionFactory sessionFactory, @NotNull TrustedKeyDao trustedKeyDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.trustedKeyDao = trustedKeyDao;
    }

    @Override
    @NotNull
    protected TrustedKey createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new TrustedKeyImpl();
    }

    @Override
    protected void importProperties(@NotNull TrustedKey object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        TrustedKeyImpl trustedKey = (TrustedKeyImpl)Narrow.downTo((Object)object, TrustedKeyImpl.class);
        String elementLocalName = inputCursor.getLocalName();
        if (KEY.equals(elementLocalName)) {
            trustedKey.setKey(inputCursor.getElemStringValue());
        } else if (HOST.equals(elementLocalName)) {
            trustedKey.setHost(inputCursor.getElemStringValue());
        } else if (APPROVED.equals(elementLocalName)) {
            trustedKey.setApproved(inputCursor.getElemBooleanValue());
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull TrustedKey trustedKey, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, trustedKey, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(HOST, trustedKey.getHost()).append(APPROVED, trustedKey.isApproved()).append(KEY, trustedKey.getKey());
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.trustedKeyDao.findAll(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.flush();
        session.clear();
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<TrustedKey> list, @NotNull TrustedKey object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)object);
    }
}

