/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.exception;

import com.atlassian.crowd.embedded.api.PasswordConstraint;
import com.atlassian.crowd.embedded.api.PasswordPolicyConfiguration;
import com.atlassian.crowd.exception.CrowdException;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Nullable;

public class InvalidCredentialException
extends CrowdException {
    @Nullable
    private final PasswordPolicyConfiguration passwordPolicyConfiguration;
    @Nullable
    private final Collection<PasswordConstraint> violatedConstraints;
    @Nullable
    private final String policyDescription;

    public InvalidCredentialException() {
        this.passwordPolicyConfiguration = null;
        this.policyDescription = null;
        this.violatedConstraints = null;
    }

    public InvalidCredentialException(String message) {
        super(message);
        this.passwordPolicyConfiguration = null;
        this.policyDescription = null;
        this.violatedConstraints = null;
    }

    public InvalidCredentialException(String genericMessage, @Nullable String policyDescription, Collection<PasswordConstraint> violatedConstraints) {
        super((String)(policyDescription == null ? genericMessage : genericMessage + ": " + policyDescription));
        this.passwordPolicyConfiguration = null;
        this.policyDescription = policyDescription;
        this.violatedConstraints = new LinkedList<PasswordConstraint>(violatedConstraints);
    }

    public InvalidCredentialException(String policyDescription, Collection<PasswordConstraint> violatedConstraints) {
        super(policyDescription);
        this.passwordPolicyConfiguration = null;
        this.policyDescription = policyDescription;
        this.violatedConstraints = violatedConstraints;
    }

    public InvalidCredentialException(String policyDescription, PasswordPolicyConfiguration passwordPolicyConfiguration, Collection<PasswordConstraint> violatedConstraints) {
        super(policyDescription);
        this.passwordPolicyConfiguration = passwordPolicyConfiguration;
        this.policyDescription = policyDescription;
        this.violatedConstraints = violatedConstraints;
    }

    public InvalidCredentialException(String message, Throwable cause) {
        super(message, cause);
        this.passwordPolicyConfiguration = null;
        this.policyDescription = null;
        this.violatedConstraints = null;
    }

    public InvalidCredentialException(Throwable throwable) {
        super(throwable);
        this.passwordPolicyConfiguration = null;
        this.policyDescription = null;
        this.violatedConstraints = null;
    }

    @Nullable
    public PasswordPolicyConfiguration getPasswordPolicyConfiguration() {
        return this.passwordPolicyConfiguration;
    }

    @Nullable
    public String getPolicyDescription() {
        return this.policyDescription;
    }

    @Nullable
    public Collection<PasswordConstraint> getViolatedConstraints() {
        return this.violatedConstraints;
    }
}

