/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.impl;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserComparator;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;

public class ImmutableUser
implements User,
Serializable {
    private static final long serialVersionUID = -4472223017071267465L;
    private final long directoryId;
    private final String name;
    private final boolean active;
    private final String emailAddress;
    private final String displayName;

    public ImmutableUser(long directoryId, @Nonnull String name, String displayName, String emailAddress, boolean active) {
        this.directoryId = directoryId;
        this.name = Objects.requireNonNull(name);
        this.displayName = displayName == null ? "" : displayName;
        this.emailAddress = emailAddress;
        this.active = active;
    }

    public static ImmutableUser from(User user) {
        if (user instanceof ImmutableUser) {
            return (ImmutableUser)user;
        }
        return ImmutableUser.newUser(user).toUser();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public long getDirectoryId() {
        return this.directoryId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean equals(Object o) {
        return UserComparator.equalsObject(this, o);
    }

    @Override
    public int hashCode() {
        return UserComparator.hashCode(this);
    }

    @Override
    public int compareTo(User other) {
        return UserComparator.compareTo(this, other);
    }

    public static Builder newUser() {
        return new Builder();
    }

    public static Builder newUser(User user) {
        Builder builder = ImmutableUser.newUser().directoryId(user.getDirectoryId());
        builder.name(user.getName());
        builder.active(user.isActive());
        builder.displayName(user.getDisplayName());
        builder.emailAddress(user.getEmailAddress());
        return builder;
    }

    public static final class Builder {
        private long directoryId = -1L;
        private String name;
        private String displayName;
        private String emailAddress;
        private boolean active = true;

        public ImmutableUser toUser() {
            return new ImmutableUser(this.directoryId, this.name, this.displayName, this.emailAddress, this.active);
        }

        public Builder directoryId(long directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }
    }
}

