/*
 * Decompiled with CFR 0.152.
 */
package it;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jpo.apis.Version;
import com.atlassian.jpo.jira.api.project.ProjectCreationData;
import com.atlassian.jpo.jira.api.project.ProjectServiceBridge;
import com.atlassian.jpo.jira.api.project.ProjectServiceBridgeProxy;
import com.atlassian.plugins.osgi.test.AtlassianPluginsTestRunner;
import com.atlassian.test.categories.OnDemandAcceptanceTest;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.info.InfoExtension;
import com.radiantminds.roadmap.common.extensions.projects.IssueTypeData;
import com.radiantminds.roadmap.common.extensions.projects.ListProjectResult;
import com.radiantminds.roadmap.common.extensions.projects.ProjectAccess;
import com.radiantminds.roadmap.common.extensions.projects.ProjectData;
import com.radiantminds.roadmap.common.extensions.projects.ProjectExtension;
import com.radiantminds.roadmap.common.extensions.projects.ProjectIssueTypeData;
import it.BaseIntegrationTest;
import it.login.Login;
import it.login.User;
import java.util.Set;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=AtlassianPluginsTestRunner.class)
@Category(value={OnDemandAcceptanceTest.class})
public class ProjectExtensionTest
extends BaseIntegrationTest {
    private final ProjectExtension projectExtension;
    private final InfoExtension infoExtension;
    private final ProjectService projectService;
    private final ProjectServiceBridgeProxy projectServiceBridgeProxy;

    public ProjectExtensionTest(ProjectExtension projectExtension, InfoExtension infoExtension, ProjectService projectService, ProjectServiceBridgeProxy projectServiceBridgeProxy) {
        this.projectExtension = projectExtension;
        this.infoExtension = infoExtension;
        this.projectService = projectService;
        this.projectServiceBridgeProxy = projectServiceBridgeProxy;
    }

    @Test
    public void testExcluded() throws Exception {
        this.withProjects(new Function(){

            @Override
            public void apply() throws Exception {
                ListProjectResult listProjectResult = ProjectExtensionTest.this.projectExtension.listProjects(ProjectAccess.BROWSE, null, null, null, true);
                Assert.assertEquals((long)(3 + ProjectExtensionTest.this.getProjectCount()), (long)listProjectResult.getProjects().size());
                ListProjectResult excludedListProjectResult = ProjectExtensionTest.this.projectExtension.listProjects(ProjectAccess.BROWSE, null, null, (Set)Sets.newHashSet((Object[])new Long[]{((ProjectData)listProjectResult.getProjects().get(0)).getId()}), true);
                Assert.assertEquals((long)(2 + ProjectExtensionTest.this.getProjectCount()), (long)excludedListProjectResult.getProjects().size());
                Assert.assertFalse((boolean)excludedListProjectResult.isMoreAvailable());
            }
        });
    }

    @Test
    public void testBaseRetrieval61() throws Exception {
        if (this.isVersionLessThanOrEqualTo64()) {
            this.testBaseRetrieval(new String[]{"summary", "issuetype", "reporter"}, 6);
        }
    }

    @Test
    public void testBaseRetrieval641() throws Exception {
        if (this.isVersionAbove64AndBelow70()) {
            this.testBaseRetrieval(new String[]{"summary", "issuetype", "reporter", "assignee"}, 6);
        }
    }

    @Test
    public void testBaseRetrieval70() throws Exception {
        if (this.isVersionAbove65()) {
            this.testBaseRetrieval(new String[]{"summary", "issuetype", "reporter"}, 4);
        }
    }

    private void testBaseRetrieval(final String[] requiredFields, final int expectedIssueTypeCount) throws Exception {
        this.withProjects(new Function(){

            @Override
            public void apply() throws Exception {
                ListProjectResult listProjectResult = ProjectExtensionTest.this.projectExtension.listProjects(ProjectAccess.BROWSE, null, null, null, true);
                Assert.assertEquals((long)(3 + ProjectExtensionTest.this.getProjectCount()), (long)listProjectResult.getProjects().size());
                Assert.assertFalse((boolean)listProjectResult.isMoreAvailable());
                Assert.assertNotNull((Object)listProjectResult.getEpicIssueType());
                Assert.assertNotNull((Object)listProjectResult.getStoryPointsField());
                Assert.assertNotNull((Object)listProjectResult.getEpicLabelField());
                Assert.assertNotNull((Object)listProjectResult.getEpicLinkField());
                ProjectData fooAProject = (ProjectData)Iterables.find((Iterable)listProjectResult.getProjects(), (Predicate)new Predicate<ProjectData>(){

                    public boolean apply(@Nullable ProjectData projectData) {
                        return "FOOA".equals(projectData.getKey());
                    }
                });
                Assert.assertEquals((Object)"FOOA", (Object)fooAProject.getKey());
                Assert.assertEquals((Object)"FOOA", (Object)fooAProject.getName());
                ProjectData testDataProject = (ProjectData)Iterables.find((Iterable)listProjectResult.getProjects(), (Predicate)new Predicate<ProjectData>(){

                    public boolean apply(@Nullable ProjectData projectData) {
                        return ProjectExtensionTest.this.scrumProject.getKey().equals(projectData.getKey());
                    }
                });
                Assert.assertEquals((Object)ProjectExtensionTest.this.scrumProject.getKey(), (Object)testDataProject.getKey());
                Assert.assertEquals((long)expectedIssueTypeCount, (long)testDataProject.getIssueTypes().size());
                ProjectIssueTypeData bugIssueTypeData = (ProjectIssueTypeData)Iterables.find((Iterable)testDataProject.getIssueTypes(), (Predicate)new Predicate<ProjectIssueTypeData>(){

                    public boolean apply(@Nullable ProjectIssueTypeData input) {
                        return input.getId().equals("1");
                    }
                });
                Assert.assertEquals((long)requiredFields.length, (long)bugIssueTypeData.getRequiredFields().size());
                for (String requiredField : requiredFields) {
                    Assert.assertTrue((boolean)bugIssueTypeData.getRequiredFields().contains(requiredField));
                }
                Assert.assertEquals((long)6L, (long)listProjectResult.getIssueTypes().size());
                IssueTypeData story = (IssueTypeData)Iterables.find((Iterable)listProjectResult.getIssueTypes(), (Predicate)new Predicate<IssueTypeData>(){

                    public boolean apply(@Nullable IssueTypeData input) {
                        return input.getName().equals("Story");
                    }
                });
                Assert.assertEquals((Object)"Story", (Object)story.getName());
                Assert.assertEquals((Object)"Created by JIRA Agile - do not edit or delete. Issue type for a user story.", (Object)story.getDescription());
                Assert.assertTrue((boolean)story.getIconUrl().startsWith("http://"));
                Assert.assertFalse((boolean)story.isSubTask());
                Assert.assertTrue((boolean)story.isStoryPointsEnabled());
            }
        });
    }

    @Test
    public void testLimitedRetrieval() throws Exception {
        this.withProjects(new Function(){

            @Override
            public void apply() throws Exception {
                ListProjectResult listProjectResult = ProjectExtensionTest.this.projectExtension.listProjects(ProjectAccess.BROWSE, null, Integer.valueOf(3), null, true);
                Assert.assertEquals((long)3L, (long)listProjectResult.getProjects().size());
                Assert.assertTrue((boolean)listProjectResult.isMoreAvailable());
            }
        });
    }

    @Test
    public void testQueryStringRetrieval() throws Exception {
        this.withProjects(new Function(){

            @Override
            public void apply() throws Exception {
                ListProjectResult listProjectResult = ProjectExtensionTest.this.projectExtension.listProjects(ProjectAccess.BROWSE, "FOO", null, null, true);
                Assert.assertEquals((long)3L, (long)listProjectResult.getProjects().size());
                Assert.assertFalse((boolean)listProjectResult.isMoreAvailable());
            }
        });
    }

    @Test
    public void testDefaultedProjectAccessWithoutDefault() throws Exception {
        this.withProjects(new Function(){

            @Override
            public void apply() throws Exception {
                ProjectService.GetProjectResult getProjectResult = ProjectExtensionTest.this.projectService.getProjectByKey(ProjectExtensionTest.this.getCurrentUser(), "FOOA");
                ListProjectResult listProjectResult = ProjectExtensionTest.this.projectExtension.getDefaultedProject(ProjectAccess.BROWSE, getProjectResult.getProject().getId(), true);
                Assert.assertEquals((long)1L, (long)listProjectResult.getProjects().size());
                Assert.assertEquals((Object)"FOOA", (Object)((ProjectData)listProjectResult.getProjects().get(0)).getKey());
            }
        });
    }

    @Test
    public void testDefaultedProjectAccessWithDefault() throws Exception {
        long nonExistentId = 999999L;
        this.withProjects(new Function(){

            @Override
            public void apply() throws Exception {
                ListProjectResult listProjectResult = ProjectExtensionTest.this.projectExtension.getDefaultedProject(ProjectAccess.BROWSE, Long.valueOf(999999L), true);
                Assert.assertEquals((long)1L, (long)listProjectResult.getProjects().size());
                Assert.assertEquals((Object)"FOOA", (Object)((ProjectData)listProjectResult.getProjects().get(0)).getKey());
            }
        });
    }

    @Test
    public void testDefaultedProjectWithRequiredFields() throws Exception {
        this.withProjects(new Function(){

            @Override
            public void apply() throws Exception {
                ProjectService.GetProjectResult getProjectResult = ProjectExtensionTest.this.projectService.getProjectByKey(ProjectExtensionTest.this.getCurrentUser(), "FOOA");
                ListProjectResult listProjectResult = ProjectExtensionTest.this.projectExtension.getDefaultedProject(ProjectAccess.BROWSE, getProjectResult.getProject().getId(), true);
                Assert.assertEquals((long)1L, (long)listProjectResult.getProjects().size());
                Assert.assertEquals((Object)"FOOA", (Object)((ProjectData)listProjectResult.getProjects().get(0)).getKey());
                Assert.assertTrue((boolean)((ProjectIssueTypeData)((ProjectData)listProjectResult.getProjects().get(0)).getIssueTypes().get(0)).getRequiredFields().contains("summary"));
                Assert.assertTrue((boolean)((ProjectIssueTypeData)((ProjectData)listProjectResult.getProjects().get(0)).getIssueTypes().get(0)).getRequiredFields().contains("issuetype"));
                Assert.assertTrue((boolean)((ProjectIssueTypeData)((ProjectData)listProjectResult.getProjects().get(0)).getIssueTypes().get(0)).getRequiredFields().contains("reporter"));
            }
        });
    }

    @Test
    public void testDefaultedProjectWithoutRequiredFields() throws Exception {
        this.withProjects(new Function(){

            @Override
            public void apply() throws Exception {
                ProjectService.GetProjectResult getProjectResult = ProjectExtensionTest.this.projectService.getProjectByKey(ProjectExtensionTest.this.getCurrentUser(), "FOOA");
                ListProjectResult listProjectResult = ProjectExtensionTest.this.projectExtension.getDefaultedProject(ProjectAccess.BROWSE, getProjectResult.getProject().getId(), false);
                Assert.assertEquals((long)1L, (long)listProjectResult.getProjects().size());
                Assert.assertEquals((Object)"FOOA", (Object)((ProjectData)listProjectResult.getProjects().get(0)).getKey());
                Assert.assertEquals((long)0L, (long)((ProjectIssueTypeData)((ProjectData)listProjectResult.getProjects().get(0)).getIssueTypes().get(0)).getRequiredFields().size());
            }
        });
    }

    @Test
    public void testListProjectsWithRequiredFields() throws Exception {
        this.withProjects(new Function(){

            @Override
            public void apply() throws Exception {
                ListProjectResult listProjectResult = ProjectExtensionTest.this.projectExtension.listProjects(ProjectAccess.BROWSE, null, null, null, true);
                Assert.assertTrue((boolean)((ProjectIssueTypeData)((ProjectData)listProjectResult.getProjects().get(0)).getIssueTypes().get(0)).getRequiredFields().contains("summary"));
                Assert.assertTrue((boolean)((ProjectIssueTypeData)((ProjectData)listProjectResult.getProjects().get(0)).getIssueTypes().get(0)).getRequiredFields().contains("issuetype"));
                Assert.assertTrue((boolean)((ProjectIssueTypeData)((ProjectData)listProjectResult.getProjects().get(0)).getIssueTypes().get(0)).getRequiredFields().contains("reporter"));
            }
        });
    }

    @Test
    public void testListProjectsWithoutRequiredFields() throws Exception {
        this.withProjects(new Function(){

            @Override
            public void apply() throws Exception {
                ListProjectResult listProjectResult = ProjectExtensionTest.this.projectExtension.listProjects(ProjectAccess.BROWSE, null, null, null, false);
                Assert.assertEquals((long)0L, (long)((ProjectIssueTypeData)((ProjectData)listProjectResult.getProjects().get(0)).getIssueTypes().get(0)).getRequiredFields().size());
            }
        });
    }

    @Test
    @Login(user=User.NON_ADMIN)
    public void testSecurityReadAccess() throws Exception {
        ListProjectResult listProjectResult = this.projectExtension.listProjects(ProjectAccess.BROWSE, null, null, null, true);
        Assert.assertEquals((long)2L, (long)listProjectResult.getProjects().size());
    }

    @Test
    @Login(user=User.NON_ADMIN)
    public void testSecurityWriteAccess() throws Exception {
        ListProjectResult listProjectResult = this.projectExtension.listProjects(ProjectAccess.CREATE_ISSUES, null, null, null, true);
        Assert.assertEquals((long)1L, (long)listProjectResult.getProjects().size());
    }

    @Test
    @Login(user=User.NON_ADMIN)
    public void testSecurityWriteAccessForAdminAccess() throws Exception {
        ListProjectResult listProjectResult = this.projectExtension.listProjects(ProjectAccess.ADMINISTRATE, null, null, null, true);
        Assert.assertEquals((long)0L, (long)listProjectResult.getProjects().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withProjects(Function func) throws Exception {
        int i;
        String[] keys = new String[]{"FOOA", "FOOB", "FOOC"};
        try {
            for (i = 0; i < 3; ++i) {
                ProjectCreationData projectCreationData = new ProjectCreationData.Builder().withName(keys[i]).withKey(keys[i]).withDescription(keys[i]).withLead(this.getCurrentUser()).withUrl("http://www.atlassian.com").build();
                ProjectService.CreateProjectValidationResult createProjectValidationResult = ((ProjectServiceBridge)this.projectServiceBridgeProxy.get()).validateCreateProject(this.getCurrentUser(), projectCreationData);
                this.projectService.createProject(createProjectValidationResult);
            }
            func.apply();
        }
        finally {
            for (i = 0; i < 3; ++i) {
                ProjectService.DeleteProjectValidationResult deleteValidationResult = this.projectService.validateDeleteProject(this.getCurrentUser(), keys[i]);
                this.projectService.deleteProject(this.getCurrentUser(), deleteValidationResult);
            }
        }
    }

    private boolean isVersionLessThanOrEqualTo64() {
        Version sixFourOne = new Version("6.4.1");
        return !this.infoExtension.meetsVersionRequirements(sixFourOne);
    }

    private boolean isVersionAbove64AndBelow70() {
        Version sixFourOne = new Version("6.4.1");
        Version sevenZero = new Version("7.0");
        return this.infoExtension.meetsVersionRequirements(sixFourOne) && !this.infoExtension.meetsVersionRequirements(sevenZero);
    }

    private boolean isVersionAbove65() {
        Version sevenZero = new Version("7.0");
        return this.infoExtension.meetsVersionRequirements(sevenZero);
    }

    private static interface Function {
        public void apply() throws Exception;
    }
}

