/*
 * Decompiled with CFR 0.152.
 */
package it;

import com.atlassian.jira.bc.issue.link.IssueLinkService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jpo.jira.api.issue.IssueServiceBridge;
import com.atlassian.jpo.jira.api.issue.IssueServiceBridgeProxy;
import com.atlassian.jpo.jira.api.issue.link.IssueLinkServiceBridge;
import com.atlassian.jpo.jira.api.issue.link.IssueLinkServiceBridgeProxy;
import com.atlassian.plugins.osgi.test.AtlassianPluginsTestRunner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.workitems.IssueLinkRequest;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import it.BaseIntegrationTest;
import it.login.Login;
import it.login.User;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=AtlassianPluginsTestRunner.class)
public class WorkItemExtensionTest
extends BaseIntegrationTest {
    private final WorkItemExtension workItemExtension;
    private final JiraAuthenticationContext authenticationContext;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueServiceBridgeProxy issueServiceBridgeProxy;
    private final IssueLinkServiceBridgeProxy issueLinkServiceBridgeProxy;

    public WorkItemExtensionTest(WorkItemExtension workItemExtension, JiraAuthenticationContext authenticationContext, IssueLinkTypeManager issueLinkTypeManager, IssueServiceBridgeProxy issueServiceBridgeProxy, IssueLinkServiceBridgeProxy issueLinkServiceBridge) {
        this.workItemExtension = workItemExtension;
        this.authenticationContext = authenticationContext;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueServiceBridgeProxy = issueServiceBridgeProxy;
        this.issueLinkServiceBridgeProxy = issueLinkServiceBridge;
    }

    @Test
    @Login(user=User.ADMIN)
    public void testCreateInwardDependency() throws Exception {
        IssueLinkRequest request = new IssueLinkRequest(){

            public List<String> getInwardIds() {
                return Lists.newArrayList((Object[])new String[]{"SCRUM-2"});
            }

            public List<String> getOutwardIds() {
                return Lists.newArrayList();
            }

            public Set<String> getIssueKeys() {
                return Sets.newHashSet((Object[])new String[]{"SCRUM-3"});
            }

            public String getLinkTypeId() {
                return "10000";
            }
        };
        this.workItemExtension.createIssueLinksForDependencies(request);
        ApplicationUser authenticatedUser = this.authenticationContext.getUser();
        MutableIssue targetIssue = ((IssueServiceBridge)this.issueServiceBridgeProxy.get()).getIssue(authenticatedUser, "SCRUM-3").getIssue();
        MutableIssue inwardIssue = ((IssueServiceBridge)this.issueServiceBridgeProxy.get()).getIssue(authenticatedUser, "SCRUM-2").getIssue();
        IssueLinkService.IssueLinkResult linkResult = ((IssueLinkServiceBridge)this.issueLinkServiceBridgeProxy.get()).getIssueLinks(authenticatedUser, (Issue)targetIssue);
        IssueLinkType dependencyLinkType = this.issueLinkTypeManager.getIssueLinkType(Long.valueOf(10000L));
        Assert.assertTrue((boolean)linkResult.getLinkCollection().getLinkTypes().contains(dependencyLinkType));
        Assert.assertNotNull((Object)linkResult);
        Assert.assertTrue((boolean)linkResult.isValid());
        Assert.assertEquals((Object)true, (Object)linkResult.getLinkCollection().getAllIssues().contains(inwardIssue));
        Assert.assertTrue((linkResult.getLinkCollection().getInwardIssues(dependencyLinkType.getName()).size() == 1 ? 1 : 0) != 0);
    }

    @Test
    @Login(user=User.ADMIN)
    public void testCreateOutwardDependency() throws Exception {
        IssueLinkRequest request = new IssueLinkRequest(){

            public List<String> getInwardIds() {
                return Lists.newArrayList();
            }

            public List<String> getOutwardIds() {
                return Lists.newArrayList((Object[])new String[]{"SCRUM-2"});
            }

            public Set<String> getIssueKeys() {
                return Sets.newHashSet((Object[])new String[]{"SCRUM-3"});
            }

            public String getLinkTypeId() {
                return "10000";
            }
        };
        this.workItemExtension.createIssueLinksForDependencies(request);
        ApplicationUser authenticatedUser = this.authenticationContext.getUser();
        MutableIssue targetIssue = ((IssueServiceBridge)this.issueServiceBridgeProxy.get()).getIssue(authenticatedUser, "SCRUM-3").getIssue();
        MutableIssue outwardIssue = ((IssueServiceBridge)this.issueServiceBridgeProxy.get()).getIssue(authenticatedUser, "SCRUM-2").getIssue();
        IssueLinkService.IssueLinkResult linkResult = ((IssueLinkServiceBridge)this.issueLinkServiceBridgeProxy.get()).getIssueLinks(authenticatedUser, (Issue)targetIssue);
        IssueLinkType dependencyLinkType = this.issueLinkTypeManager.getIssueLinkType(Long.valueOf(10000L));
        Assert.assertTrue((boolean)linkResult.getLinkCollection().getLinkTypes().contains(dependencyLinkType));
        Assert.assertNotNull((Object)linkResult);
        Assert.assertTrue((boolean)linkResult.isValid());
        Assert.assertEquals((Object)true, (Object)linkResult.getLinkCollection().getAllIssues().contains(outwardIssue));
        Assert.assertTrue((linkResult.getLinkCollection().getOutwardIssues(dependencyLinkType.getName()).size() == 1 ? 1 : 0) != 0);
    }

    @Test
    @Login(user=User.ADMIN)
    public void testCreateDependenciesWithoutMatchingIssues() throws Exception {
        IssueLinkRequest request = new IssueLinkRequest(){

            public List<String> getInwardIds() {
                return Lists.newArrayList();
            }

            public List<String> getOutwardIds() {
                return Lists.newArrayList();
            }

            public Set<String> getIssueKeys() {
                return Sets.newHashSet((Object[])new String[]{"SCRUM-1"});
            }

            public String getLinkTypeId() {
                return "10000";
            }
        };
        this.workItemExtension.createIssueLinksForDependencies(request);
        ApplicationUser authenticatedUser = this.authenticationContext.getUser();
        MutableIssue targetIssue = ((IssueServiceBridge)this.issueServiceBridgeProxy.get()).getIssue(authenticatedUser, "SCRUM-1").getIssue();
        IssueLinkService.IssueLinkResult linkResult = ((IssueLinkServiceBridge)this.issueLinkServiceBridgeProxy.get()).getIssueLinks(authenticatedUser, (Issue)targetIssue);
        Assert.assertNotNull((Object)linkResult);
        Assert.assertTrue((boolean)linkResult.getLinkCollection().getAllIssues().isEmpty());
    }
}

