/*
 * Decompiled with CFR 0.152.
 */
package it.testutils;

import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;

public class ProjectRoleUtils {
    private final ProjectRoleService projectRoleService;

    public ProjectRoleUtils(ProjectRoleService projectRoleService) {
        this.projectRoleService = projectRoleService;
    }

    public void setInvisiblePermissions(Project project) {
        this.removeGroupFromRole("jira-users", "Users", project);
        this.addGroupToRole("jira-administrators", "Users", project);
    }

    private void removeGroupFromRole(String groupName, String roleName, Project project) {
        SimpleErrorCollection getRolesErrors = new SimpleErrorCollection();
        ProjectRole usersRole = this.projectRoleService.getProjectRoleByName(roleName, (ErrorCollection)getRolesErrors);
        HashSet usersGroup = Sets.newHashSet((Object[])new String[]{groupName});
        SimpleErrorCollection removeActorsErrors = new SimpleErrorCollection();
        this.projectRoleService.removeActorsFromProjectRole((Collection)usersGroup, usersRole, project, "atlassian-group-role-actor", (ErrorCollection)removeActorsErrors);
    }

    private void addGroupToRole(String groupName, String roleName, Project project) {
        SimpleErrorCollection getRolesErrors = new SimpleErrorCollection();
        ProjectRole usersRole = this.projectRoleService.getProjectRoleByName(roleName, (ErrorCollection)getRolesErrors);
        SimpleErrorCollection addActorsErrors = new SimpleErrorCollection();
        HashSet adminsGroup = Sets.newHashSet((Object[])new String[]{groupName});
        this.projectRoleService.addActorsToProjectRole((Collection)adminsGroup, usersRole, project, "atlassian-group-role-actor", (ErrorCollection)addActorsErrors);
    }
}

