/*
 * Decompiled with CFR 0.152.
 */
package it.testutils;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jpo.jira.api.login.LoginServiceBridge;
import com.atlassian.jpo.jira.api.login.LoginServiceBridgeProxy;
import it.login.Login;
import it.login.ProjectCreationLogin;
import it.login.User;
import org.junit.runner.Description;

public class UserSwitcher {
    private final UserManager userManager;
    private final LoginServiceBridgeProxy loginServiceBridgeProxy;
    private final JiraAuthenticationContext authenticationContext;
    private User baseUser;
    private User projectCreationUser;
    private ApplicationUser user;

    public UserSwitcher(UserManager userManager, LoginServiceBridgeProxy loginServiceBridgeProxy, JiraAuthenticationContext authenticationContext) {
        this.userManager = userManager;
        this.loginServiceBridgeProxy = loginServiceBridgeProxy;
        this.authenticationContext = authenticationContext;
    }

    public void configureUsersForTest(Description usersDescription) {
        this.baseUser = this.getBaseUserOrDefaultToAdmin(usersDescription);
        this.projectCreationUser = this.getProjectCreationUserOrDefaultToBaseUser(usersDescription);
        this.login(this.baseUser);
    }

    private User getBaseUserOrDefaultToAdmin(Description usersDescription) {
        Login login = (Login)usersDescription.getAnnotation(Login.class);
        return login != null ? login.user() : User.ADMIN;
    }

    private User getProjectCreationUserOrDefaultToBaseUser(Description usersDescription) {
        ProjectCreationLogin projectCreationLogin = (ProjectCreationLogin)usersDescription.getAnnotation(ProjectCreationLogin.class);
        return projectCreationLogin != null ? projectCreationLogin.user() : this.baseUser;
    }

    public ApplicationUser getCurrentUser() {
        return this.user;
    }

    public void loginAsProjectCreationUser() {
        if (this.baseUser != this.projectCreationUser) {
            this.login(this.projectCreationUser);
        }
    }

    public void loginAsBaseUser() {
        if (this.baseUser != this.projectCreationUser) {
            this.login(this.baseUser);
        }
    }

    public void login(User user) {
        ApplicationUser applicationUser = this.userManager.getUserByName(user.getUsername());
        ((LoginServiceBridge)this.loginServiceBridgeProxy.get()).authenticate(applicationUser, user.getPassword());
        this.authenticationContext.setLoggedInUser(applicationUser);
        ((LoginServiceBridge)this.loginServiceBridgeProxy.get()).authenticate(this.authenticationContext.getUser(), user.getPassword());
        this.user = this.authenticationContext.getUser();
    }
}

