/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.boards;

import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.atlassian.greenhopper.service.PageRequests;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.rapid.view.RapidViewQuery;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.web.rapid.view.RapidViewPreset;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.AgileServiceOutcomeException;
import com.atlassian.rm.common.bridges.agile.boards.AgileBoard;
import com.atlassian.rm.common.bridges.agile.boards.AgileBoardServiceBridge;
import com.atlassian.rm.common.bridges.agile.boards.DefaultAgileBoard;
import com.atlassian.rm.common.bridges.agile.common.service.BundleServiceServiceResultHandler;
import com.atlassian.rm.common.bridges.agile.service.BundleServiceServiceOutcomeHandler;
import com.atlassian.rm.common.bridges.agile.service.ServiceOutcomeHandlerAction;
import com.atlassian.rm.common.bridges.agile.service.UnsafeBundleServiceServiceOutcomeHandler;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessorProvider;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.agile.boards.AgileBoardServiceBridgeCloud")
@SupportedVersions(all=true)
public class AgileBoardServiceBridgeCloud
implements AgileBoardServiceBridge {
    private static final String RAPID_VIEW_SERVICE_NAME = "com.atlassian.greenhopper.service.rapid.view.RapidViewService";
    private static final String RAPID_VIEW_MANAGER_COMPONENT_NAME = "rapidViewManagerImpl";
    private static final String RAPID_VIEW_NOT_FOUND_ERROR_KEY = "gh.rapid.view.error.noview";
    private final BundleServiceServiceResultHandler rapidViewServiceServiceResultHandler;
    private final BundleServiceServiceOutcomeHandler rapidViewServiceServiceOutcomeHandler;
    private final UnsafeBundleServiceServiceOutcomeHandler rapidViewManagerServiceOutcomeHandler;

    @Autowired
    public AgileBoardServiceBridgeCloud(BundleServiceAccessorProvider bundleServiceAccessorProvider) {
        this.rapidViewServiceServiceOutcomeHandler = new BundleServiceServiceOutcomeHandler(bundleServiceAccessorProvider, RAPID_VIEW_SERVICE_NAME);
        this.rapidViewServiceServiceResultHandler = new BundleServiceServiceResultHandler(bundleServiceAccessorProvider, RAPID_VIEW_SERVICE_NAME);
        this.rapidViewManagerServiceOutcomeHandler = new UnsafeBundleServiceServiceOutcomeHandler(bundleServiceAccessorProvider, "com.pyxis.greenhopper.jira", RAPID_VIEW_MANAGER_COMPONENT_NAME);
    }

    @Override
    public AgileBoard createAgileBoard(final ApplicationUser applicationUser, final String name, final Long filterId, final AgileBoard.Type type) throws AgileServiceOutcomeException, AgileNotAvailableException {
        return this.rapidViewServiceServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<RapidViewService, ServiceOutcome, RapidView, AgileBoard>(){

            @Override
            public ServiceOutcome getServiceOutcome(RapidViewService rapidViewService) {
                return rapidViewService.create(applicationUser, name, filterId, (RapidViewPreset)AgileBoardServiceBridgeCloud.this.getRapidViewPreset(type));
            }

            @Override
            public AgileBoard getResult(RapidView rapidView) {
                return new DefaultAgileBoard(rapidView.getId(), rapidView.getName(), rapidView.getSavedFilterId(), AgileBoardServiceBridgeCloud.this.getAgileBoardType(rapidView));
            }
        });
    }

    @Override
    public void deleteAgileBoard(final ApplicationUser applicationUser, long boardId) throws AgileServiceOutcomeException, AgileNotAvailableException {
        RapidView.RapidViewBuilder builder = new RapidView.RapidViewBuilder();
        final RapidView rapidView = builder.id(Long.valueOf(boardId)).build();
        this.rapidViewServiceServiceResultHandler.perform(new BundleServiceServiceResultHandler.Action<RapidViewService, ServiceResult>(){

            @Override
            public ServiceResult getServiceResult(RapidViewService rapidViewService) {
                return rapidViewService.delete(applicationUser, rapidView);
            }
        });
    }

    @Override
    public Optional<AgileBoard> getAgileBoard(final ApplicationUser applicationUser, final long boardId) throws AgileServiceOutcomeException, AgileNotAvailableException {
        return this.rapidViewServiceServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<RapidViewService, ServiceOutcome, RapidView, Optional<AgileBoard>>(){

            @Override
            public ServiceOutcome getServiceOutcome(RapidViewService rapidViewService) {
                return rapidViewService.getRapidView(applicationUser, Long.valueOf(boardId));
            }

            @Override
            public Optional<AgileBoard> getResult(RapidView rapidView) {
                DefaultAgileBoard board = new DefaultAgileBoard(rapidView.getId(), rapidView.getName(), rapidView.getSavedFilterId(), AgileBoardServiceBridgeCloud.this.getAgileBoardType(rapidView));
                return Optional.of((Object)board);
            }

            @Override
            public Optional<AgileBoard> handleErrors(ServiceOutcome serviceOutcome) throws AgileServiceOutcomeException {
                if (this.hasSingleError(serviceOutcome, AgileBoardServiceBridgeCloud.RAPID_VIEW_NOT_FOUND_ERROR_KEY)) {
                    return Optional.absent();
                }
                return (Optional)super.handleErrors(serviceOutcome);
            }
        });
    }

    @Override
    public Optional<AgileBoard> getAgileBoardWithoutPermissionCheck(final long boardId) throws AgileServiceOutcomeException, AgileNotAvailableException {
        return this.rapidViewManagerServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<RapidViewManager, ServiceOutcome, RapidView, Optional<AgileBoard>>(){

            @Override
            public ServiceOutcome getServiceOutcome(RapidViewManager rapidViewManager) {
                return rapidViewManager.get(Long.valueOf(boardId));
            }

            @Override
            public Optional<AgileBoard> getResult(RapidView rapidView) {
                DefaultAgileBoard board = new DefaultAgileBoard(rapidView.getId(), rapidView.getName(), rapidView.getSavedFilterId(), AgileBoardServiceBridgeCloud.this.getAgileBoardType(rapidView));
                return Optional.of((Object)board);
            }

            @Override
            public Optional<AgileBoard> handleErrors(ServiceOutcome serviceOutcome) throws AgileServiceOutcomeException {
                if (this.hasSingleError(serviceOutcome, AgileBoardServiceBridgeCloud.RAPID_VIEW_NOT_FOUND_ERROR_KEY)) {
                    return Optional.absent();
                }
                return (Optional)super.handleErrors(serviceOutcome);
            }
        });
    }

    @Override
    public List<AgileBoard> findAgileBoards(final ApplicationUser applicationUser, final String query) throws AgileServiceOutcomeException, AgileNotAvailableException {
        return this.rapidViewServiceServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<RapidViewService, ServiceOutcome, Page<RapidView>, List<AgileBoard>>(){

            @Override
            public ServiceOutcome getServiceOutcome(RapidViewService rapidViewService) {
                PageRequest request = PageRequests.request((Long)0L, (Integer)50);
                RapidViewQuery queryObject = new RapidViewQuery.Builder().partialName(query).build();
                return rapidViewService.getRapidViews(applicationUser, request, queryObject);
            }

            @Override
            public List<AgileBoard> getResult(Page<RapidView> rapidViews) {
                return Lists.newArrayList((Iterable)Iterables.transform((Iterable)rapidViews.getValues(), (Function)new Function<RapidView, AgileBoard>(){

                    public AgileBoard apply(@Nullable RapidView rapidView) {
                        return new DefaultAgileBoard(rapidView.getId(), rapidView.getName(), rapidView.getSavedFilterId(), AgileBoardServiceBridgeCloud.this.getAgileBoardType(rapidView));
                    }
                }));
            }
        });
    }

    private Object getRapidViewPreset(AgileBoard.Type type) {
        switch (type) {
            case SCRUM: {
                return RapidViewPreset.SCRUM;
            }
            case KANBAN: {
                return RapidViewPreset.KANBAN;
            }
        }
        throw new IllegalArgumentException("Unknown AgileBoard.Type " + (Object)((Object)type));
    }

    private AgileBoard.Type getAgileBoardType(Object rapidView) {
        switch (((RapidView)rapidView).getType()) {
            case SCRUM: {
                return AgileBoard.Type.SCRUM;
            }
            case KANBAN: {
                return AgileBoard.Type.KANBAN;
            }
        }
        throw new IllegalArgumentException("Unknown RapidView type: " + ((RapidView)rapidView).getType());
    }
}

