/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.rank;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldNotAvailableException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldServiceBridge;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldsServiceBridgeProxy;
import com.atlassian.rm.common.bridges.agile.rank.AgileDefaultRankDomainRankServiceBridge;
import com.atlassian.rm.common.bridges.agile.rank.AgileRankOperationResponse;
import com.atlassian.rm.common.bridges.agile.rank.AnonymousRankService;
import com.atlassian.rm.common.bridges.agile.rank.AuthorizedRankService;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.agile.rank.IssueDomainRankServiceBridgeCloud")
@SupportedVersions(all=true)
public class IssueDomainRankServiceBridgeCloud
implements AgileDefaultRankDomainRankServiceBridge {
    private static final Log LOGGER = Log.with(IssueDomainRankServiceBridgeCloud.class);
    private final AuthorizedRankService authorizedRankService;
    private final AnonymousRankService anonymousRankService;
    private final AgileCustomFieldsServiceBridgeProxy rankCustomFieldService;

    @Autowired
    public IssueDomainRankServiceBridgeCloud(AuthorizedRankService authorizedRankService, AnonymousRankService anonymousRankService, AgileCustomFieldsServiceBridgeProxy rankCustomFieldService) {
        this.authorizedRankService = authorizedRankService;
        this.anonymousRankService = anonymousRankService;
        this.rankCustomFieldService = rankCustomFieldService;
    }

    @Override
    public AgileRankOperationResponse rankFirst(List<Long> ids) throws Exception {
        return this.authorizedRankService.rankFirst(ids, this.getDefaultRankDomain());
    }

    @Override
    public AgileRankOperationResponse rankLast(List<Long> ids) throws Exception {
        return this.authorizedRankService.rankLast(ids, this.getDefaultRankDomain());
    }

    @Override
    public AgileRankOperationResponse rankBefore(List<Long> ids, long anchorId) throws Exception {
        return this.authorizedRankService.rankBefore(ids, anchorId, this.getDefaultRankDomain());
    }

    @Override
    public AgileRankOperationResponse rankAfter(List<Long> ids, long anchorId) throws Exception {
        return this.authorizedRankService.rankAfter(ids, anchorId, this.getDefaultRankDomain());
    }

    @Override
    public ImmutableList<Long> sort(Collection<Long> ids) throws Exception {
        return this.anonymousRankService.sort(ids, this.getDefaultRankDomain());
    }

    @Override
    public ImmutableMap<Long, String> getRankValues(Collection<Long> ids) throws Exception {
        return this.anonymousRankService.getRankValues(ids, this.getDefaultRankDomain());
    }

    @Override
    public void delete(long id) throws Exception {
        this.authorizedRankService.delete(id);
    }

    private long getDefaultRankDomain() throws AgileNotAvailableException, AgileCustomFieldNotAvailableException {
        long rankDomain = ((AgileCustomFieldServiceBridge)this.rankCustomFieldService.get()).getRankField().getIdAsLong();
        LOGGER.debug("use default rank domain: %d", rankDomain);
        return rankDomain;
    }
}

