/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.sprints;

import com.atlassian.rm.common.bridges.agile.sprints.AgileSprint;
import com.google.common.base.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DefaultAgileSprint
implements AgileSprint {
    private final long id;
    private final Optional<Long> agileBoardId;
    private final AgileSprint.State state;
    private final String title;
    private final Optional<Long> sequence;
    private final Optional<Long> startDate;
    private final Optional<Long> endDate;
    private final Optional<Long> completeDate;

    private DefaultAgileSprint(long id, String title, Long agileBoardId, AgileSprint.State state, Long sequence, Long startDate, Long endDate, Long completeDate) {
        this.id = id;
        this.title = title;
        this.agileBoardId = Optional.fromNullable((Object)agileBoardId);
        this.state = state;
        this.sequence = Optional.fromNullable((Object)sequence);
        this.startDate = Optional.fromNullable((Object)startDate);
        this.endDate = Optional.fromNullable((Object)endDate);
        this.completeDate = Optional.fromNullable((Object)completeDate);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Optional<Long> getAgileBoardId() {
        return this.agileBoardId;
    }

    @Override
    public AgileSprint.State getState() {
        return this.state;
    }

    @Override
    public Optional<Long> getSequence() {
        return this.sequence;
    }

    @Override
    public Optional<Long> getStartDate() {
        return this.startDate;
    }

    @Override
    public Optional<Long> getEndDate() {
        return this.endDate;
    }

    @Override
    public Optional<Long> getCompleteDate() {
        return this.completeDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultAgileSprint that = (DefaultAgileSprint)o;
        return new EqualsBuilder().append(this.id, that.id).append(this.agileBoardId, that.agileBoardId).append((Object)this.state, (Object)that.state).append(this.title, that.title).append(this.sequence, that.sequence).append(this.startDate, that.startDate).append(this.endDate, that.endDate).append(this.completeDate, that.completeDate).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.id).append(this.agileBoardId).append((Object)this.state).append(this.title).append(this.sequence).append(this.startDate).append(this.endDate).append(this.completeDate).toHashCode();
    }

    public static Builder builder(AgileSprint agileSprint) {
        return new Builder().id(agileSprint.getId()).title(agileSprint.getTitle()).agileBoardId((Long)agileSprint.getAgileBoardId().orNull()).state(agileSprint.getState()).sequence((Long)agileSprint.getSequence().orNull()).startDate((Long)agileSprint.getStartDate().orNull()).endDate((Long)agileSprint.getEndDate().orNull()).completeDate((Long)agileSprint.getCompleteDate().orNull());
    }

    public static class Builder {
        private long id;
        private String title;
        private Long agileBoardId;
        private AgileSprint.State state;
        private Long sequence;
        private Long startDate;
        private Long endDate;
        private Long completeDate;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder agileBoardId(Long agileBoardId) {
            this.agileBoardId = agileBoardId;
            return this;
        }

        public Builder state(AgileSprint.State state) {
            this.state = state;
            return this;
        }

        public Builder sequence(Long sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder startDate(Long startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(Long endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder completeDate(Long completeDate) {
            this.completeDate = completeDate;
            return this;
        }

        public DefaultAgileSprint build() {
            return new DefaultAgileSprint(this.id, this.title, this.agileBoardId, this.state, this.sequence, this.startDate, this.endDate, this.completeDate);
        }
    }
}

