/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.issue.labels;

import com.atlassian.jira.bc.issue.label.LabelService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.issue.labels.IssueLabelServiceBridge;
import com.atlassian.rm.common.bridges.jira.issue.labels.IssueLabelServiceException;
import com.google.common.base.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.issue.labels.IssueLabelServiceBridgeCloud")
@SupportedVersions(all=true)
class IssueLabelServiceBridgeCloud
implements IssueLabelServiceBridge {
    private final LabelService labelService;

    @Autowired
    IssueLabelServiceBridgeCloud(LabelService labelService) {
        this.labelService = labelService;
    }

    @Override
    public void setLabels(ApplicationUser user, long issueId, Set<String> labels) throws IssueLabelServiceException {
        LabelService.SetLabelValidationResult setLabelValidationResult = this.labelService.validateSetLabels(user, Long.valueOf(issueId), labels);
        if (!setLabelValidationResult.isValid()) {
            throw new IssueLabelServiceException(setLabelValidationResult.getErrorCollection());
        }
        this.labelService.setLabels(user, setLabelValidationResult, true, true);
    }

    @Override
    public Set<String> getSuggestedLabels(ApplicationUser user, Optional<Long> issueId, Optional<String> searchString) throws IssueLabelServiceException {
        LabelService.LabelSuggestionResult suggestedLabels = this.labelService.getSuggestedLabels(user, (Long)issueId.orNull(), (String)searchString.orNull());
        if (!suggestedLabels.isValid()) {
            throw new IssueLabelServiceException(suggestedLabels.getErrorCollection());
        }
        return suggestedLabels.getSuggestions();
    }
}

