/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.license;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.rm.common.bridges.api.RequiredFeatures;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.license.LicenseData;
import com.atlassian.rm.common.bridges.jira.license.LicenseErrorType;
import com.atlassian.rm.common.bridges.jira.license.LicenseServiceBridge;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.LicenseType;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.license.LicenseServiceBridge63")
@RequiredFeatures(unless={"com.atlassian.rm.portfolio.vertigo.Licensing"})
@SupportedVersions(all=true)
class LicenseServiceBridge63
implements LicenseServiceBridge {
    @ComponentImport
    @Autowired(required=false)
    private PluginLicenseManager licenseManager;
    @Autowired
    private FeatureManager featureManager;

    @Override
    public boolean isLicensed() {
        return this.getLicenseData().isValid();
    }

    @Override
    public LicenseData getLicenseData() {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.licenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                LicenseError licenseError = (LicenseError)license.getError().get();
                if (licenseError == LicenseError.EXPIRED && !license.isEvaluation() && license.getLicenseType() != LicenseType.TESTING && !this.featureManager.isOnDemand()) {
                    return LicenseData.createValid();
                }
                String details = "No detail information available.";
                LicenseErrorType licenseErrorType = LicenseErrorType.Unlicensed;
                switch (licenseError) {
                    case EXPIRED: {
                        details = LicenseServiceBridge63.getLicenseErrorDetails(license, "Your license for Portfolio for JIRA has expired.");
                        licenseErrorType = LicenseErrorType.Expired;
                        break;
                    }
                    case TYPE_MISMATCH: {
                        details = LicenseServiceBridge63.getLicenseErrorDetails(license, "Invalid license: Your license for Portfolio for JIRA does not match the license type on this JIRA installation.");
                        licenseErrorType = LicenseErrorType.TypeMismatch;
                        break;
                    }
                    case USER_MISMATCH: {
                        details = LicenseServiceBridge63.getLicenseErrorDetails(license, "Portfolio for JIRA is only licensed for a limited number of users that has been exceeded.");
                        licenseErrorType = LicenseErrorType.UserMismatch;
                        break;
                    }
                    case VERSION_MISMATCH: {
                        details = LicenseServiceBridge63.getLicenseErrorDetails(license, "Your license for maintenance of Portfolio for JIRA is not valid for the installed add-on version.");
                        licenseErrorType = LicenseErrorType.VersionMismatch;
                    }
                }
                return LicenseData.createInvalid(licenseError.name(), licenseErrorType, details);
            }
            return LicenseData.createValid();
        }
        return LicenseData.createInvalid("Portfolio for JIRA is not licensed.", LicenseErrorType.Unlicensed, "Please purchase a license or get an evaluation license if you want to use this add-on.");
    }

    private static String getLicenseErrorDetails(PluginLicense license, String customMessage) {
        StringBuffer retVal = new StringBuffer();
        retVal.append(customMessage + "\n");
        retVal.append("\tLicense SEN: " + (license.getSupportEntitlementNumber().isDefined() ? (String)license.getSupportEntitlementNumber().get() : "Unknown") + "\n");
        retVal.append("\tLicense version: " + (license.getLicenseVersion().isDefined() ? (Serializable)license.getLicenseVersion().get() : "Unknown") + "\n");
        retVal.append("\tLicense violation: " + (license.getError().isDefined() ? ((LicenseError)license.getError().get()).name() : "Unknown") + "\n");
        retVal.append("\tLicense type: " + license.getLicenseType().name() + (license.isEvaluation() ? " (EVALUATION)" : " (STANDARD)") + "\n");
        retVal.append("\tMax. users: " + (license.getMaximumNumberOfUsers().isDefined() ? (Serializable)license.getMaximumNumberOfUsers().get() : "Unknown") + "\n");
        retVal.append("\tExpiry date: " + (license.getExpiryDate().isDefined() ? (Serializable)license.getExpiryDate().get() : "Unknown") + "\n");
        retVal.append("\tMaintenance expiry date: " + (license.getMaintenanceExpiryDate().isDefined() ? (Serializable)license.getMaintenanceExpiryDate().get() : "Unknown") + "\n");
        return retVal.toString();
    }
}

