/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.license;

import com.atlassian.jira.license.TenantContextLicensedProducts;
import com.atlassian.rm.common.bridges.api.RequiredFeatures;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.license.LicenseData;
import com.atlassian.rm.common.bridges.jira.license.LicenseErrorType;
import com.atlassian.rm.common.bridges.jira.license.LicenseServiceBridge;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.license.LicenseServiceBridgeVertigo")
@RequiredFeatures(value={"com.atlassian.rm.portfolio.vertigo.Licensing"})
@SupportedVersions(all=true)
class LicenseServiceBridgeVertigo
implements LicenseServiceBridge {
    private static final String PRODUCT_KEY = "com.radiantminds.roadmaps-jira";
    private final TenantContextLicensedProducts tenantContextLicensedProducts;

    @Autowired
    public LicenseServiceBridgeVertigo(TenantContextLicensedProducts tenantContextLicensedProducts) {
        this.tenantContextLicensedProducts = tenantContextLicensedProducts;
    }

    @Override
    public boolean isLicensed() {
        return this.tenantContextLicensedProducts.isProductLicensed(PRODUCT_KEY);
    }

    @Override
    public LicenseData getLicenseData() {
        if (this.isLicensed()) {
            return LicenseData.createValid();
        }
        return LicenseData.createInvalid("Not licensed", LicenseErrorType.Unlicensed, null);
    }
}

