/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.lifecycle;

import cloud.atlassian.upgrade.api.ServerDowngradeTask;
import cloud.atlassian.upgrade.api.UpgradeTask;
import cloud.atlassian.upgrade.api.UpgradeTaskFactory;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.jira.lifecycle.JiraUpgradeTask;
import com.atlassian.rm.common.bridges.jira.lifecycle.UpgradeTaskServiceBridgeVertigo;
import com.atlassian.rm.common.bridges.jira.lifecycle.UpgradeTaskWrapper;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;

class JpoUpgradeTaskFactory
implements UpgradeTaskFactory {
    private static final Log LOGGER = Log.with(JpoUpgradeTaskFactory.class);
    private static final String PRODUCT_MIN_VERSION = "2.0.0";
    private static final int MIN_BUILD_NUMBER = 0;
    private final UpgradeTaskServiceBridgeVertigo upgradeTaskServiceBridgeVertigo;

    @Inject
    public JpoUpgradeTaskFactory(UpgradeTaskServiceBridgeVertigo upgradeTaskServiceBridgeVertigo) {
        this.upgradeTaskServiceBridgeVertigo = upgradeTaskServiceBridgeVertigo;
    }

    public String getProductDisplayName() {
        LOGGER.debug("return product display name", new Object[0]);
        return this.upgradeTaskServiceBridgeVertigo.getDisplayName();
    }

    public String getProductMinimumVersion() {
        LOGGER.debug("return minimum version", new Object[0]);
        return PRODUCT_MIN_VERSION;
    }

    public int getMinimumBuildNumber() {
        LOGGER.debug("return minimum build", new Object[0]);
        return 0;
    }

    @Nonnull
    public Collection<UpgradeTask> getAllUpgradeTasks() {
        LOGGER.debug("return %d upgrade tasks: %s", this.upgradeTaskServiceBridgeVertigo.getUpgradeTasks().size(), Iterables.toString(this.upgradeTaskServiceBridgeVertigo.getUpgradeTasks()));
        return this.upgradeTaskServiceBridgeVertigo.getUpgradeTasks().stream().map(t -> new UpgradeTaskWrapper((JiraUpgradeTask)t)).collect(Collectors.toSet());
    }

    public Collection<ServerDowngradeTask> getAllServerDowngradeTasks() {
        LOGGER.debug("return empty server downgrade tasks", new Object[0]);
        return Collections.emptyList();
    }
}

