/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.properties;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.BridgeManager;
import com.atlassian.rm.common.bridges.api.FeatureAccessor;
import com.atlassian.rm.common.bridges.api.NoBridgeAvailableException;
import com.atlassian.rm.common.bridges.api.Version;
import com.atlassian.rm.common.bridges.jira.SimpleJiraVersionAccessor;
import com.atlassian.rm.common.bridges.jira.properties.JiraPropertiesBridge;
import com.atlassian.rm.common.bridges.jira.properties.JiraPropertiesBridgeProxy;
import com.google.common.base.Optional;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.properties.DefaultJiraPropertiesBridgeProxy")
class DefaultJiraPropertiesBridgeProxy
implements JiraPropertiesBridgeProxy {
    private static final Log LOGGER = Log.with(DefaultJiraPropertiesBridgeProxy.class);
    private final SimpleJiraVersionAccessor versionAccessor;
    private final BridgeManager<JiraPropertiesBridge> bridgeManager;

    @Autowired
    protected DefaultJiraPropertiesBridgeProxy(SimpleJiraVersionAccessor jiraVersionAccessor, List<JiraPropertiesBridge> beans) {
        this.versionAccessor = jiraVersionAccessor;
        this.bridgeManager = new BridgeManager<JiraPropertiesBridge>(beans, (Optional<FeatureAccessor>)Optional.absent());
    }

    @Override
    public JiraPropertiesBridge get() {
        Version apiVersion = this.versionAccessor.getVersion();
        Optional<JiraPropertiesBridge> supportedBridge = this.bridgeManager.getSupportedBridge(apiVersion);
        if (supportedBridge.isPresent()) {
            JiraPropertiesBridge bridge = (JiraPropertiesBridge)supportedBridge.get();
            LOGGER.debug(String.format("Bridge implementation %s chosen for API version %s.", bridge.getClass(), apiVersion.toString()), new Object[0]);
            return bridge;
        }
        LOGGER.warn(String.format("No bridge implementation for %s available for API version %s.", JiraPropertiesBridge.class.toString(), apiVersion.toString()), new Object[0]);
        throw new NoBridgeAvailableException(apiVersion, JiraPropertiesBridge.class);
    }

    private Collection<JiraPropertiesBridge> getAvailableBridges() {
        Version apiVersion = this.versionAccessor.getVersion();
        return this.bridgeManager.getAllVersionCompatibleBridges(apiVersion);
    }
}

