/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.threading;

import com.atlassian.messagequeue.MessageRunnerKey;
import com.atlassian.messagequeue.registry.MessageRunnerRegistryService;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.threading.LongRunningExecutorRegistryBridge;
import com.atlassian.rm.common.bridges.jira.threading.LongRunningTask;
import com.atlassian.rm.common.bridges.jira.threading.LongRunningTaskProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.threading.LongRunningExecutorRegistryBridgeCloud")
@SupportedVersions(all=true)
class LongRunningExecutorRegistryBridgeCloud
implements LongRunningExecutorRegistryBridge {
    private static final Log LOGGER = Log.with(LongRunningExecutorRegistryBridgeCloud.class);
    private final MessageRunnerRegistryService messageRunnerRegistryService;

    @Autowired
    public LongRunningExecutorRegistryBridgeCloud(MessageRunnerRegistryService messageRunnerRegistryService) {
        this.messageRunnerRegistryService = messageRunnerRegistryService;
    }

    @Override
    public void register(LongRunningTaskProvider longRunningTaskProvider) {
        LOGGER.debug("Registering longRunningTaskProvider '%s' in BridgeVertigo.", longRunningTaskProvider.getKey());
        this.messageRunnerRegistryService.registerMessageRunner(MessageRunnerKey.of((String)longRunningTaskProvider.getKey()), messageContext -> {
            String payload = messageContext.getPayload().orElse(null);
            messageContext.acknowledge();
            try {
                LongRunningTask task = longRunningTaskProvider.getLongRunningTask(payload);
                task.run(() -> {});
            }
            catch (Exception e) {
                LOGGER.errorDebug(e, "Async message '%s' could not be processed.", payload);
            }
        });
    }
}

