/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IBacklogState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.ICausalDependencyState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IEpisodeState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.ITemporalDependencyState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.ItemAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IterativeSolutionState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.PossibleEpisodeTracker;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IItemAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.FixedSlotItemsSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.FixedSlotsAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.UnstructuredItemState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IUnstructuredItem;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

class BacklogState
implements IBacklogState {
    private final int planningHorizon;
    private final ICausalDependencyState causalDependencyState;
    private final ITemporalDependencyState temporalDependencyState;
    private final UnstructuredItemState unstructuredItemState;
    private final List<IProcessingItem> openBacklogItems;
    private final PossibleEpisodeTracker possibleEpisodeTracker;

    BacklogState(ICausalDependencyState causalDependencyState, ITemporalDependencyState temporalDependencyState, UnstructuredItemState unstructuredItemState, List<IProcessingItem> items, int planningHorizon, PossibleEpisodeTracker possibleEpisodeTracker) {
        this.causalDependencyState = causalDependencyState;
        this.temporalDependencyState = temporalDependencyState;
        this.openBacklogItems = Lists.newArrayList(items);
        this.possibleEpisodeTracker = possibleEpisodeTracker;
        this.planningHorizon = planningHorizon;
        this.unstructuredItemState = unstructuredItemState;
    }

    @Override
    public Optional<Integer> getEpisodeStartTime(String episodeId) {
        return this.temporalDependencyState.getEpisodeState(episodeId).getStartTime();
    }

    @Override
    public LinkedHashMap<IEpisode, Optional<Integer>> getPossibleEpisodesForItem(String itemId) {
        LinkedHashMap episodeToStartMap = Maps.newLinkedHashMap();
        for (IEpisode episode : this.possibleEpisodeTracker.getPossibleEpisodesForItem(itemId)) {
            episodeToStartMap.put(episode, this.temporalDependencyState.getEpisodeState(episode.getId()).getStartTime());
        }
        return episodeToStartMap;
    }

    @Override
    public Optional<IItemAssignmentProblem> tryGetNextProblem() {
        for (IProcessingItem item : this.openBacklogItems) {
            IEpisode episode;
            IEpisodeState episodeState;
            Optional<IItemAssignmentProblem> problem;
            Optional<Integer> causalReleaseTime;
            if (!this.possibleEpisodeTracker.isToBeDone(item.getId()) || !(causalReleaseTime = this.causalDependencyState.getCausalReleaseTime(item.getId())).isPresent() || !(problem = ItemAssignmentProblem.tryCreateInstance(item, episodeState = this.temporalDependencyState.getEpisodeState((episode = this.possibleEpisodeTracker.getNextPossibleEpisode(item.getId())).getId()), (Integer)causalReleaseTime.get(), this.isEnforced(item.getId()), this.planningHorizon)).isPresent()) continue;
            return problem;
        }
        return Optional.absent();
    }

    @Override
    public void addResult(String itemId, String episodeId, @Nullable IActivitySetSchedule schedule) {
        if (this.detectAndHandleSchedulingFail(schedule, itemId, episodeId)) {
            return;
        }
        this.possibleEpisodeTracker.setDone(itemId);
        this.openBacklogItems.remove(schedule.getActivitySet());
        this.causalDependencyState.setFinishedItemWithSchedule(schedule.getId(), schedule);
        this.temporalDependencyState.setFinishedItemWithId(itemId, episodeId, schedule.getEnd());
    }

    @Override
    public void addResult(String itemId, String episodeId, @Nullable IUnstructuredItemSchedule schedule) {
        if (this.detectAndHandleSchedulingFail(schedule, itemId, episodeId)) {
            return;
        }
        Optional<IUnstructuredItem> updatedItem = this.updateUnstructuredItem(schedule);
        if (updatedItem.isPresent()) {
            this.causalDependencyState.updateCausalReleaseTime(itemId, schedule.getEnd() + 1);
            return;
        }
        this.possibleEpisodeTracker.setDone(itemId);
        this.causalDependencyState.setFinishedItemWithSchedule(schedule.getId(), schedule);
        this.temporalDependencyState.setFinishedItemWithId(itemId, episodeId, schedule.getEnd());
    }

    @Override
    public Set<String> addSchedulingException(String itemId, String episodeId) {
        this.causalDependencyState.setUnschedulableItem(itemId);
        this.temporalDependencyState.setFinishedItemWithId(itemId, episodeId, 0);
        this.openBacklogItems.remove(RmIdentifiableUtils.tryFindElementWithId(itemId, Sets.newHashSet(this.openBacklogItems)).get());
        this.possibleEpisodeTracker.setDone(itemId);
        return this.handleUnschedulableDependents(itemId);
    }

    private Set<String> handleUnschedulableDependents(String itemId) {
        Set<String> dependeeIds = this.causalDependencyState.getTransitiveDependees(itemId);
        HashSet dependees = Sets.newHashSet();
        for (IProcessingItem item : this.openBacklogItems) {
            String depItemId = item.getId();
            if (!dependeeIds.contains(depItemId)) continue;
            this.causalDependencyState.setUnschedulableItem(depItemId);
            if (item.isStrictlyAssigned()) {
                this.temporalDependencyState.setFailForItemIdEpisodeId(depItemId, (String)item.getFixedEpisodeId().get());
            }
            dependees.add(RmIdentifiableUtils.tryFindElementWithId(depItemId, Sets.newHashSet(this.openBacklogItems)).get());
        }
        this.openBacklogItems.removeAll(dependees);
        this.possibleEpisodeTracker.setDone(dependeeIds);
        return dependeeIds;
    }

    @Override
    public void addFixedSlotItemSolutions(FixedSlotsAssignmentSolution slotsAssignmentSolution, IterativeSolutionState solutionState) {
        Set<FixedSlotItemsSolution> fixedSlotItemSolution = slotsAssignmentSolution.getSlotSolutions();
        for (FixedSlotItemsSolution slotItemSolution : fixedSlotItemSolution) {
            Set<IProcessingItem> processingItems = slotItemSolution.getProcessingItems();
            for (IProcessingItem item : processingItems) {
                this.openBacklogItems.remove(item);
                this.possibleEpisodeTracker.setDone(item.getId());
                if (slotItemSolution.getViolations().isEmpty()) {
                    this.causalDependencyState.setFinishedItemWithSchedule(item.getId(), slotItemSolution);
                } else {
                    this.causalDependencyState.setUnschedulableItem(item.getId());
                    solutionState.addViolations(slotItemSolution.getViolations().iterator().next(), this.handleUnschedulableDependents(item.getId()));
                }
                if (!item.isStrictlyAssigned()) continue;
                this.temporalDependencyState.setFinishedItemWithId(item.getId(), (String)item.getFixedEpisodeId().get(), slotItemSolution.getEnd());
            }
        }
    }

    @Override
    public boolean isSplitItem(String itemId) {
        return this.unstructuredItemState.isSplitItem(itemId);
    }

    private boolean isEnforced(String itemId) {
        return this.possibleEpisodeTracker.getPossibleEpisodesForItem(itemId).size() == 1;
    }

    private boolean detectAndHandleSchedulingFail(IItemSchedule schedule, String itemId, String episodeId) {
        this.possibleEpisodeTracker.setFailed(itemId, episodeId);
        if (schedule == null) {
            this.temporalDependencyState.setFailForItemIdEpisodeId(itemId, episodeId);
            return true;
        }
        return false;
    }

    private Optional<IUnstructuredItem> updateUnstructuredItem(IUnstructuredItemSchedule schedule) {
        for (int i = 0; i < this.openBacklogItems.size(); ++i) {
            IProcessingItem processingItem = this.openBacklogItems.get(i);
            if (!processingItem.getId().equals(schedule.getId())) continue;
            this.openBacklogItems.remove(i);
            Optional<IUnstructuredItem> newItem = this.unstructuredItemState.tryGetRemaining(schedule, processingItem);
            if (newItem.isPresent()) {
                this.openBacklogItems.add(i, (IProcessingItem)newItem.get());
            }
            return newItem;
        }
        return Optional.absent();
    }
}

