/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.calculation.CalculationProgressMonitor;
import com.atlassian.rm.jpo.scheduling.calculation.CalculationState;
import com.atlassian.rm.jpo.scheduling.calculation.NoOpCalculationState;
import com.atlassian.rm.jpo.scheduling.calculation.ProgressInformation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.IRoadmapScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.BacklogStateInitializer;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IBacklogState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IterativeSolutionState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.RoadmapScheduleCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.ActivitySetSchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.EnforcedActivitySetScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetSchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IEnforcedActivitySetScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IOptionalActivitySetScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.OptionalActivitySetScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IItemAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.ItemNotSchedulableException;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.MutableResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.ReachedPlanningHorizonException;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.FixedSlotAssignmentSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.FixedSlotsAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.FixedSlotsAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.IFixedSlotsAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.IterativeMultiSlotAssignmentSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.EnforcedUnstructuredItemScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.EnforcedUnstructuredScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.IUnstructuredItemSchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.OptionalUnstructuredItemScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.OptionalUnstructuredScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.UnstructuredItemSchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.ItemNotSchedulableViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.PlanningHorizonReachedWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.UnstructuredItemNotFullyScheduledWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IRoadmapSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ProcessingItemType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.solver.DefaultSolverConfiguration;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.solver.SolverConfiguration;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;

@Immutable
public class GreedyRoadmapScheduler
implements IRoadmapScheduler {
    private static final Log LOGGER = Log.with(GreedyRoadmapScheduler.class);
    private final IEnforcedActivitySetScheduler enforcedActSet;
    private final IOptionalActivitySetScheduler optionalActSet;
    private final EnforcedUnstructuredItemScheduler enforcedUnstruct;
    private final OptionalUnstructuredItemScheduler optionalUnstruct;
    private final CalculationProgressMonitor progressMonitor;
    private final FixedSlotAssignmentSolver fixedSlotAssignmentSolver = new IterativeMultiSlotAssignmentSolver();
    private final RoadmapScheduleCreator scheduleCreator = new RoadmapScheduleCreator();
    private final BacklogStateInitializer backlogStateInitializer = new BacklogStateInitializer();

    public GreedyRoadmapScheduler(IEnforcedActivitySetScheduler enforcedActSet, IOptionalActivitySetScheduler optionalActSet, EnforcedUnstructuredItemScheduler enforcedUnstruct, OptionalUnstructuredItemScheduler optionalUnstruct, CalculationProgressMonitor progressMonitor) {
        this.enforcedActSet = enforcedActSet;
        this.optionalActSet = optionalActSet;
        this.enforcedUnstruct = enforcedUnstruct;
        this.optionalUnstruct = optionalUnstruct;
        this.progressMonitor = progressMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRoadmapSchedule schedule(IRoadmapProblem problem) throws InterruptedException {
        Stopwatch stopwatch = SimonManager.getStopwatch("calculation");
        Split split = stopwatch.start();
        try {
            Set<IMutableResourceGroup> mutableResourceGroups = GreedyRoadmapScheduler.createMutableResourceGroups(problem.getResourceGroups());
            IBacklogState backlogState = this.backlogStateInitializer.initialize(problem);
            IterativeSolutionState solutionState = IterativeSolutionState.createInstance();
            FixedSlotsAssignmentSolution fixedSprintSolutionState = (FixedSlotsAssignmentSolution)this.handleFixedSlotProblem(problem, mutableResourceGroups, backlogState, solutionState).orNull();
            this.scheduleWorkItems(problem, mutableResourceGroups, backlogState, solutionState);
            IRoadmapSchedule roadmap = this.scheduleCreator.createRoadMapSchedule(problem, solutionState, backlogState, fixedSprintSolutionState);
            LogUtil.debug(LOGGER, "created roadmap: %s", roadmap);
            IRoadmapSchedule iRoadmapSchedule = roadmap;
            return iRoadmapSchedule;
        }
        finally {
            split.stop();
        }
    }

    private static Set<IMutableResourceGroup> createMutableResourceGroups(Set<IResourceGroup> resourceGroups) {
        Preconditions.checkNotNull(resourceGroups, (Object)"set of resource groups must not be null");
        HashSet mutableGroups = Sets.newHashSet();
        for (IResourceGroup group : resourceGroups) {
            mutableGroups.add(MutableResourceGroup.createMutableResourceGroup(group));
        }
        return mutableGroups;
    }

    private void scheduleWorkItems(IRoadmapProblem problem, Set<IMutableResourceGroup> mutableResourceGroups, IBacklogState backlogState, IterativeSolutionState solutionState) throws InterruptedException {
        Optional<IItemAssignmentProblem> nextProblem;
        while ((nextProblem = backlogState.tryGetNextProblem()).isPresent()) {
            Set<String> depenendeeIds;
            String itemId;
            Object schedule;
            this.progressMonitor.setProgress(new ProgressInformation(problem.getBacklog().getProcessingItems().size(), solutionState.getProcessdItemCount()));
            IItemAssignmentProblem assignmentProblem = (IItemAssignmentProblem)nextProblem.get();
            LogUtil.debug(LOGGER, "\ntry schedule work item with ID: %s", assignmentProblem.getId());
            IEpisode nextEpisode = assignmentProblem.getProjectEpisode();
            solutionState.addIfNotKnown(nextEpisode);
            ProcessingItemType itemType = assignmentProblem.getProcessingItemType();
            if (ProcessingItemType.ActivitySet.equals((Object)itemType)) {
                IActivitySetSchedulingProblem activitySetProblem = ActivitySetSchedulingProblem.createInstance(assignmentProblem, mutableResourceGroups, problem);
                try {
                    schedule = this.scheduleActivitySet(activitySetProblem);
                    backlogState.addResult(assignmentProblem.getId(), nextEpisode.getId(), (IActivitySetSchedule)schedule.orNull());
                    solutionState.addActivitySetSchedule((IActivitySetSchedule)schedule.orNull(), nextEpisode);
                }
                catch (ItemNotSchedulableException exception) {
                    itemId = exception.getId();
                    depenendeeIds = backlogState.addSchedulingException(itemId, nextEpisode.getId());
                    solutionState.addViolations(new ItemNotSchedulableViolation(itemId), depenendeeIds);
                }
                catch (ReachedPlanningHorizonException exception) {
                    itemId = exception.getId();
                    depenendeeIds = backlogState.addSchedulingException(itemId, nextEpisode.getId());
                    solutionState.addWarning(PlanningHorizonReachedWarning.create(itemId, problem.getProcessingDefinition().getPlanningHorizon()), depenendeeIds);
                }
                continue;
            }
            if (!ProcessingItemType.Unstructured.equals((Object)itemType)) continue;
            IUnstructuredItemSchedulingProblem unstructuredProblem = UnstructuredItemSchedulingProblem.createInstance(assignmentProblem, mutableResourceGroups, problem);
            try {
                schedule = this.scheduleUnstructuredItem(unstructuredProblem);
                backlogState.addResult(assignmentProblem.getId(), nextEpisode.getId(), (IUnstructuredItemSchedule)schedule.orNull());
                solutionState.addUnstructuredItemResult((IUnstructuredItemSchedule)schedule.orNull(), nextEpisode);
            }
            catch (ItemNotSchedulableException exception) {
                solutionState.addUnstructuredItemResult((IUnstructuredItemSchedule)exception.getSchedule().orNull(), nextEpisode);
                itemId = exception.getId();
                depenendeeIds = backlogState.addSchedulingException(itemId, nextEpisode.getId());
                if (exception.getSchedule().isPresent() || backlogState.isSplitItem(itemId)) {
                    UnstructuredItemNotFullyScheduledWarning warning = UnstructuredItemNotFullyScheduledWarning.create(assignmentProblem, (IUnstructuredItemSchedule)exception.getSchedule().orNull());
                    solutionState.addWarning(warning, depenendeeIds);
                    continue;
                }
                solutionState.addViolations(new ItemNotSchedulableViolation(itemId), depenendeeIds);
            }
            catch (ReachedPlanningHorizonException exception) {
                solutionState.addUnstructuredItemResult((IUnstructuredItemSchedule)exception.getSchedule().orNull(), nextEpisode);
                itemId = exception.getId();
                depenendeeIds = backlogState.addSchedulingException(itemId, nextEpisode.getId());
                if (exception.getSchedule().isPresent() || backlogState.isSplitItem(itemId)) {
                    solutionState.addWarning(PlanningHorizonReachedWarning.create(assignmentProblem, (IUnstructuredItemSchedule)exception.getSchedule().orNull(), problem.getProcessingDefinition().getPlanningHorizon()), depenendeeIds);
                    continue;
                }
                solutionState.addWarning(PlanningHorizonReachedWarning.create(assignmentProblem.getId(), problem.getProcessingDefinition().getPlanningHorizon()), depenendeeIds);
            }
        }
    }

    private Optional<FixedSlotsAssignmentSolution> handleFixedSlotProblem(IRoadmapProblem problem, Set<IMutableResourceGroup> mutableResourceGroups, IBacklogState backlogState, IterativeSolutionState iterativeSolutionState) {
        LOGGER.debug("try to solve fixed slots", new Object[0]);
        IFixedSlotsAssignmentProblem slotsAssignmentProblem = (IFixedSlotsAssignmentProblem)FixedSlotsAssignmentProblem.tryCreate(problem).orNull();
        if (slotsAssignmentProblem == null) {
            LOGGER.debug("no fixed slots problems", new Object[0]);
            return Optional.absent();
        }
        FixedSlotsAssignmentSolution solution = this.fixedSlotAssignmentSolver.solve(slotsAssignmentProblem);
        LOGGER.debug("fixed slots solution:m %s", solution);
        backlogState.addFixedSlotItemSolutions(solution, iterativeSolutionState);
        GreedyRoadmapScheduler.updateResources(mutableResourceGroups, solution);
        return Optional.of((Object)solution);
    }

    private static void updateResources(Set<IMutableResourceGroup> mutableResourceGroups, FixedSlotsAssignmentSolution slotsAssignmentSolution) {
        for (IMutableResourceGroup resourceGroup : mutableResourceGroups) {
            resourceGroup.schedule(slotsAssignmentSolution.getAssignmentsForGroup(resourceGroup.getId()));
        }
    }

    private Optional<IUnstructuredItemSchedule> scheduleUnstructuredItem(IUnstructuredItemSchedulingProblem unstructuredProblem) throws ItemNotSchedulableException, InterruptedException, ReachedPlanningHorizonException {
        if (unstructuredProblem.isSchedulingEnforced()) {
            return Optional.of((Object)this.enforcedUnstruct.schedule(unstructuredProblem));
        }
        return this.optionalUnstruct.trySchedule(unstructuredProblem);
    }

    private Optional<IActivitySetSchedule> scheduleActivitySet(IActivitySetSchedulingProblem activitySetProblem) throws InterruptedException, ItemNotSchedulableException, ReachedPlanningHorizonException {
        if (activitySetProblem.isSchedulingEnforced()) {
            return Optional.of((Object)this.enforcedActSet.scheduleActivitySet(activitySetProblem));
        }
        return this.optionalActSet.scheduleActivitySetWithTimeLimit(activitySetProblem);
    }

    public static GreedyRoadmapScheduler createInstance(SolverConfiguration configuration, CalculationState calculationState) {
        return new GreedyRoadmapScheduler(new EnforcedActivitySetScheduler(configuration.getMaxTestAssignmentsPerTeamStage(), calculationState), new OptionalActivitySetScheduler(configuration.getMaxTestAssignmentsPerTeamStage(), calculationState), new EnforcedUnstructuredScheduler(calculationState), new OptionalUnstructuredScheduler(calculationState), calculationState);
    }

    public static GreedyRoadmapScheduler createInstance() {
        return GreedyRoadmapScheduler.createInstance(new DefaultSolverConfiguration(), new NoOpCalculationState());
    }
}

