/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IEpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IRoadmapSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.RmSchedulingUtils;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

class PrecomputedRoadmapSchedule
implements IRoadmapSchedule {
    private final IIntegerInterval activeInterval;
    private final Set<IActivitySetSchedule> activitySetSchedules;
    private final Set<IUnstructuredItemSchedule> unstructuredItemSchedules;
    private final Set<IScheduleViolation> violations;
    private final Set<IScheduleWarning> warnings;
    private final LinkedHashSet<IEpisodeSchedule> episodeSchedules;
    private final Map<ResourceSlotQueryKey, Set<IWorkAssignment>> resourceSlotMap;
    private final Set<IWorkAssignment> workAssignments;
    private final int analysisEndTime;

    private PrecomputedRoadmapSchedule(IIntegerInterval activeInterval, Set<IWorkAssignment> workAssignments, Map<ResourceSlotQueryKey, Set<IWorkAssignment>> resourceSlotMap, Set<IActivitySetSchedule> activitySetSchedules, Set<IUnstructuredItemSchedule> unstructuredItemSchedules, Set<IScheduleViolation> violations, Set<IScheduleWarning> warnings, LinkedHashSet<IEpisodeSchedule> episodeSchedules, int analysisEndTime) {
        this.activeInterval = activeInterval;
        this.activitySetSchedules = Collections.unmodifiableSet(activitySetSchedules);
        this.unstructuredItemSchedules = Collections.unmodifiableSet(unstructuredItemSchedules);
        this.violations = Collections.unmodifiableSet(violations);
        this.warnings = Collections.unmodifiableSet(warnings);
        this.episodeSchedules = episodeSchedules;
        this.workAssignments = workAssignments;
        this.resourceSlotMap = resourceSlotMap;
        this.analysisEndTime = analysisEndTime;
    }

    @Override
    public int getStart() {
        return this.activeInterval.getStart();
    }

    @Override
    public int getEnd() {
        return this.activeInterval.getEnd();
    }

    @Override
    public int getLength() {
        return this.activeInterval.getLength();
    }

    @Override
    public boolean contains(int value) {
        return this.activeInterval.contains(value);
    }

    @Override
    public Optional<IIntegerInterval> getOverlappingInterval(IIntegerInterval interval) {
        return this.activeInterval.getOverlappingInterval(interval);
    }

    @Override
    public Set<IWorkAssignment> getWorkAssignments() {
        return this.workAssignments;
    }

    @Override
    public LinkedHashSet<IEpisodeSchedule> getEpisodeSchedulesPrioOrdered() {
        return this.episodeSchedules;
    }

    @Override
    public Set<IScheduleViolation> getViolations() {
        return this.violations;
    }

    @Override
    public Set<IScheduleWarning> getWarnings() {
        return this.warnings;
    }

    @Override
    public int getAnalysisEndTime() {
        return this.analysisEndTime;
    }

    @Override
    public Set<IWorkAssignment> getWorkAssignmentsForResourceInSlot(String resourceId, int index) {
        Set<IWorkAssignment> assignments = this.resourceSlotMap.get(new ResourceSlotQueryKey(resourceId, index));
        if (assignments == null) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        return assignments;
    }

    @Override
    public Set<IActivitySetSchedule> getActivitySetSchedules() {
        return this.activitySetSchedules;
    }

    @Override
    public Set<IUnstructuredItemSchedule> getEpisodeWiseUnstructuredItemSchedules() {
        return this.unstructuredItemSchedules;
    }

    static IRoadmapSchedule createFromSolution(LinkedHashSet<IEpisodeSchedule> solutions, Set<IScheduleViolation> violations, Set<IScheduleWarning> warnings, int analysisEndTime) {
        Set<IActivitySetSchedule> allActivitySetSchedules = PrecomputedRoadmapSchedule.getActivitySetSchedules(solutions);
        Set<IUnstructuredItemSchedule> allUnstructuredSchedules = PrecomputedRoadmapSchedule.getUnstructuredSchedules(solutions);
        HashMap map = Maps.newHashMap();
        map.putAll(RmIdentifiableUtils.createIdMap(allActivitySetSchedules));
        map.putAll(PrecomputedRoadmapSchedule.getMergedUnstructured(allUnstructuredSchedules));
        PrecomputedRoadmapSchedule instance = new PrecomputedRoadmapSchedule(RmUtils.getMergedIntervals(solutions), RmSchedulingUtils.getWorkAssignments(solutions), PrecomputedRoadmapSchedule.createRsourceSlotQueryMap(RmSchedulingUtils.getWorkAssignments(solutions)), allActivitySetSchedules, allUnstructuredSchedules, violations, warnings, solutions, analysisEndTime);
        return instance;
    }

    private static Map<ResourceSlotQueryKey, Set<IWorkAssignment>> createRsourceSlotQueryMap(Set<IWorkAssignment> workAssignments) {
        HashMap assignmentMap = Maps.newHashMapWithExpectedSize((int)workAssignments.size());
        for (IWorkAssignment assignment : workAssignments) {
            RmUtils.addToKeyedSets(assignmentMap, new ResourceSlotQueryKey(assignment.getResource().getId(), assignment.getWorkSlot().getIndex()), assignment);
        }
        return assignmentMap;
    }

    private static Map<String, IIntegerInterval> getMergedUnstructured(Set<IUnstructuredItemSchedule> allUnstrucutredSchedules) {
        HashMap map = Maps.newHashMap();
        for (IUnstructuredItemSchedule schedule : allUnstrucutredSchedules) {
            String id = schedule.getId();
            if (!map.containsKey(id)) {
                map.put(id, schedule);
                continue;
            }
            map.put(id, RmUtils.getMergedIntervals(Lists.newArrayList((Object[])new IIntegerInterval[]{(IIntegerInterval)map.get(id), schedule})));
        }
        return map;
    }

    private static Set<IUnstructuredItemSchedule> getUnstructuredSchedules(LinkedHashSet<IEpisodeSchedule> solutions) {
        HashSet union = Sets.newHashSet();
        for (IEpisodeSchedule episode : solutions) {
            union.addAll(episode.getUnstructuredItemSchedules());
        }
        return union;
    }

    private static Set<IActivitySetSchedule> getActivitySetSchedules(LinkedHashSet<IEpisodeSchedule> solutions) {
        HashSet union = Sets.newHashSet();
        for (IEpisodeSchedule episode : solutions) {
            union.addAll(episode.getActivitySetSchedules());
        }
        return union;
    }

    static class ResourceSlotQueryKey {
        private final String resourceId;
        private final int slotIndex;

        ResourceSlotQueryKey(String resourceId, int slotIndex) {
            this.resourceId = resourceId;
            this.slotIndex = slotIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ResourceSlotQueryKey)) {
                return false;
            }
            ResourceSlotQueryKey key = (ResourceSlotQueryKey)o;
            if (this.slotIndex != key.slotIndex) {
                return false;
            }
            return this.resourceId.equals(key.resourceId);
        }

        public int hashCode() {
            int result = this.resourceId.hashCode();
            result = 31 * result + this.slotIndex;
            return result;
        }
    }
}

