/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetResourcePoolScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetScheduleEvaluation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetSchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetSchedulingTerminationCondition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.util.RmSortableUtils;
import com.google.common.base.Optional;
import java.util.List;
import java.util.Set;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;

public class AbstractActivitySetScheduler {
    private final IActivitySetResourcePoolScheduler activitySetResourcePoolScheduler;
    private final IActivitySetScheduleEvaluation activitySetScheduleEvalution;

    protected AbstractActivitySetScheduler(IActivitySetResourcePoolScheduler activitySetResourcePoolScheduler, IActivitySetScheduleEvaluation activitySetScheduleEvaluation) {
        this.activitySetResourcePoolScheduler = activitySetResourcePoolScheduler;
        this.activitySetScheduleEvalution = activitySetScheduleEvaluation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<IActivitySetSchedule> scheduleActivitySet(IActivitySetSchedulingProblem problem, IActivitySetSchedulingTerminationCondition terminationCondition) throws InterruptedException {
        Stopwatch stopwatch = SimonManager.getStopwatch("calculation.story");
        Split split = stopwatch.start();
        try {
            Optional optional;
            Set<IMutableResourcePool> mutableResourceGroups = problem.getMutableResourcePools();
            Optional<IActivitySetSchedule> bestSchedule = Optional.absent();
            List<IMutableResourcePool> orderedMutableResourceGroups = RmSortableUtils.sort(mutableResourceGroups);
            IMutableResourceGroup bestMutableResourceGroup = null;
            for (IMutableResourcePool mutableResourcePool : orderedMutableResourceGroups) {
                Optional<IActivitySetSchedule> schedule = this.activitySetResourcePoolScheduler.tryScheduleActivitySetForResourcePool(problem, mutableResourcePool, terminationCondition);
                if (!this.activitySetScheduleEvalution.isFirstBetterScheduleThanSecond(schedule, bestSchedule)) continue;
                bestSchedule = schedule;
                bestMutableResourceGroup = mutableResourcePool.getMutableResourceGroup();
                terminationCondition.updateBestFoundSchedule((IActivitySetSchedule)schedule.get());
            }
            if (!bestSchedule.isPresent()) {
                optional = Optional.absent();
                return optional;
            }
            bestMutableResourceGroup.schedule(((IActivitySetSchedule)bestSchedule.get()).getWorkAssignments());
            optional = bestSchedule;
            return optional;
        }
        finally {
            split.stop();
        }
    }
}

