/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.FixedSlotItemsSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.FixedSlotWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.FixedSlotsAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
class DefaultFixedSlotAssignmentSolution
implements FixedSlotsAssignmentSolution {
    private final Map<String, FixedSlotItemsSolution> itemToSlotSolutionMap;

    DefaultFixedSlotAssignmentSolution(Map<String, FixedSlotItemsSolution> itemToSlotMap) {
        this.itemToSlotSolutionMap = itemToSlotMap;
    }

    @Override
    public Set<FixedSlotWorkAssignment> getAssignmentsForGroup(String groupId) {
        HashSet assignments = Sets.newHashSet();
        for (FixedSlotItemsSolution solution : this.itemToSlotSolutionMap.values()) {
            if (!solution.getResourceGroup().getId().equals(groupId)) continue;
            assignments.addAll(solution.getWorkAssignments());
        }
        return assignments;
    }

    @Override
    public Set<FixedSlotItemsSolution> getSlotSolutions() {
        return Sets.newHashSet(this.itemToSlotSolutionMap.values());
    }

    @Override
    public Set<IProcessingItem> getProcessingItems() {
        HashSet items = Sets.newHashSet();
        for (FixedSlotItemsSolution solution : this.itemToSlotSolutionMap.values()) {
            items.addAll(solution.getProcessingItems());
        }
        return items;
    }

    @Override
    public IIntegerInterval getInterval(String itemId) {
        return this.itemToSlotSolutionMap.get(itemId);
    }

    @Override
    public Set<FixedSlotWorkAssignment> getWorkAssignmentsForItemAndStage(String itemId, Set<String> stageTaskIds, String stageId) {
        if (!this.itemToSlotSolutionMap.containsKey(itemId)) {
            return Sets.newHashSet();
        }
        HashSet assignments = Sets.newHashSet(this.itemToSlotSolutionMap.get(itemId).getWorkAssignmentsForStage(itemId, stageId));
        for (String stageTask : stageTaskIds) {
            assignments.addAll(this.itemToSlotSolutionMap.get(itemId).getWorkAssignmentsForStage(stageTask, stageId));
        }
        return assignments;
    }

    @Override
    public IWorkSlot getWorkSlot(String itemId) {
        return this.itemToSlotSolutionMap.get(itemId).getWorkSlot();
    }

    @Override
    public IResourceGroup getResourceGroup(String itemId) {
        return this.itemToSlotSolutionMap.get(itemId).getResourceGroup();
    }

    @Override
    public Set<FixedSlotWorkAssignment> getWorkAssignments(String itemId) {
        return this.itemToSlotSolutionMap.get(itemId).getWorkAssignments(itemId);
    }

    @Override
    public Set<IScheduleWarning> getWarningsForItem(String itemId) {
        FixedSlotItemsSolution slotSolution = this.itemToSlotSolutionMap.get(itemId);
        if (slotSolution == null) {
            return Sets.newHashSet();
        }
        return slotSolution.getWarnings();
    }

    @Override
    public Set<IScheduleViolation> getViolations() {
        HashSet violations = Sets.newHashSet();
        for (FixedSlotItemsSolution solution : this.itemToSlotSolutionMap.values()) {
            violations.addAll(solution.getViolations());
        }
        return violations;
    }

    @Override
    public Set<FixedSlotWorkAssignment> getWorkAssignments() {
        HashSet allAssignments = Sets.newHashSet();
        for (FixedSlotItemsSolution slotSolution : this.itemToSlotSolutionMap.values()) {
            allAssignments = Sets.union((Set)allAssignments, slotSolution.getWorkAssignments());
        }
        return allAssignments;
    }

    static FixedSlotsAssignmentSolution create(Set<FixedSlotItemsSolution> solutions) {
        HashMap itemToSlotMap = Maps.newHashMap();
        for (FixedSlotItemsSolution solution : solutions) {
            for (IProcessingItem item : solution.getProcessingItems()) {
                itemToSlotMap.put(item.getId(), solution);
            }
        }
        return new DefaultFixedSlotAssignmentSolution(itemToSlotMap);
    }
}

