/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.DecisionVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.FixedSlotWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

class FixedSlotWorkAssignmentImpl
implements FixedSlotWorkAssignment {
    private final DecisionVariable decisionVariable;
    private final IWorkSlot slot;
    private final float assignment;

    FixedSlotWorkAssignmentImpl(DecisionVariable decisionVariable, IWorkSlot slot, float assignment) {
        Preconditions.checkNotNull((Object)decisionVariable, (Object)"variable must not be null");
        Preconditions.checkNotNull((Object)slot, (Object)"work slot must not be null");
        Preconditions.checkArgument((assignment >= 0.01f ? 1 : 0) != 0);
        this.decisionVariable = decisionVariable;
        this.slot = slot;
        this.assignment = assignment;
    }

    @Override
    public String getItemId() {
        return this.decisionVariable.getAssignmentId();
    }

    @Override
    public IWorkResource getResource() {
        return this.decisionVariable.getResource();
    }

    @Override
    public IResourceType getResourceType() {
        return this.decisionVariable.getResourceType();
    }

    @Override
    public IWorkSlot getWorkSlot() {
        return this.slot;
    }

    @Override
    public float getAssignedWorkUnits() {
        return this.assignment;
    }

    @Override
    public IProcessingStage getProcessingStage() {
        return this.decisionVariable.getProcessingStage();
    }

    @Override
    public IResourceGroup getResourceGroup() {
        return this.decisionVariable.getResourceGroup();
    }

    @Override
    public int getStart() {
        return this.slot.getStart();
    }

    @Override
    public int getEnd() {
        return this.slot.getEnd();
    }

    @Override
    public int getLength() {
        return this.slot.getLength();
    }

    @Override
    public boolean contains(int value) {
        return this.slot.contains(value);
    }

    @Override
    public Optional<IIntegerInterval> getOverlappingInterval(IIntegerInterval interval) {
        return this.slot.getOverlappingInterval(interval);
    }
}

