/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.EligibleEntry;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.EligibleWorkTracker;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.IMutableAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.IUnstructuredItemSchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.MutableAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.MutableStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.MutableTimeBoundProcessingStageWorkPackageImpl;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.MutableTimeBoundStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.PartialUnstructuredItemStageProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IRoadmapProblemStatistics;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ItemSchedulingState {
    private static final Log LOGGER = Log.with(ItemSchedulingState.class);
    private final IAggregatedWorkPackage originalWorkPackage;
    private final IMutableAggregatedWorkPackage openWorkPackage;
    private final EligibleWorkTracker eligibleWorkTracker;
    private final PositivePrimitivesMap<IProcessingStage> minLoads;
    private final int upperTimeBound;
    private final int lowerTimeBound;
    private final String id;
    private final IEpisode legacyProjectEpisode;
    private final IRoadmapProblemStatistics projectStatistics;
    private final Map<IProcessingStage, Integer> freedTimeSteps;

    ItemSchedulingState(IAggregatedWorkPackage originalWorkPackage, IMutableAggregatedWorkPackage openWorkPackage, EligibleWorkTracker eligibleWorkTracker, PositivePrimitivesMap<IProcessingStage> minLoads, int lowerTimeBound, int upperTimeBound, String id, IRoadmapProblemStatistics projectStatistics, Map<IProcessingStage, Integer> freedTimeSteps, IEpisode legacyProjectEpisode) {
        this.originalWorkPackage = originalWorkPackage;
        this.openWorkPackage = openWorkPackage;
        this.eligibleWorkTracker = eligibleWorkTracker;
        this.minLoads = minLoads;
        this.lowerTimeBound = lowerTimeBound;
        this.upperTimeBound = upperTimeBound;
        this.id = id;
        this.projectStatistics = projectStatistics;
        this.freedTimeSteps = freedTimeSteps;
        this.legacyProjectEpisode = legacyProjectEpisode;
    }

    public boolean isItemFinished() {
        return this.openWorkPackage.isEmpty();
    }

    public void updateProblemState(IProcessingStageWorkPackage doneWork, IIntegerInterval workInterval) {
        Optional<MutableStageWorkPackage> remainingDoneStage;
        LogUtil.debug(LOGGER, "update problem state");
        this.openWorkPackage.decrease(doneWork);
        Optional<Integer> freedTimeStep = this.eligibleWorkTracker.updateAndGetFreedTimeStep(doneWork, workInterval, this.openWorkPackage);
        IProcessingStage doneStage = doneWork.getProcessingStage();
        Optional<IProcessingStage> nextStage = this.originalWorkPackage.getNextStage(doneStage);
        if (nextStage.isPresent() && !(remainingDoneStage = this.openWorkPackage.getWorkPackageForStage(doneStage)).isPresent()) {
            if (!freedTimeStep.isPresent()) {
                return;
            }
            LogUtil.debug(LOGGER, "add stage end for %s: %s", nextStage.get(), freedTimeStep.get());
            this.freedTimeSteps.put((IProcessingStage)nextStage.get(), (Integer)freedTimeStep.get());
        }
    }

    public Optional<PartialUnstructuredItemStageProblem> getNextStageSchedulingProblem(Set<IProcessingStage> ignoredStages) {
        LogUtil.debug(LOGGER, "try create next stage problem");
        Optional<MutableTimeBoundStageWorkPackage> nextTimeBoundWorkPackage = this.getNextTimeBoundWorkPackage(ignoredStages);
        if (!nextTimeBoundWorkPackage.isPresent()) {
            LogUtil.debug(LOGGER, "no open next work package found;");
            return Optional.absent();
        }
        PartialUnstructuredItemStageProblem nextWorkPackage = new PartialUnstructuredItemStageProblem(this.id, (MutableTimeBoundStageWorkPackage)nextTimeBoundWorkPackage.get(), this.projectStatistics, this.legacyProjectEpisode);
        LogUtil.debug(LOGGER, "created next work package: %s", nextWorkPackage);
        return Optional.of((Object)nextWorkPackage);
    }

    private Optional<MutableTimeBoundStageWorkPackage> getNextTimeBoundWorkPackage(Set<IProcessingStage> prohibitedStages) {
        List<IProcessingStage> todoStages = this.openWorkPackage.getSpecifiedStages();
        for (IProcessingStage todoStage : Lists.reverse(todoStages)) {
            if (prohibitedStages.contains(todoStage)) continue;
            MutableStageWorkPackage openWork = (MutableStageWorkPackage)this.openWorkPackage.getWorkPackageForStage(todoStage).get();
            float minWork = Math.min(openWork.getAmount(), this.minLoads.get(todoStage));
            if (this.freedTimeSteps.containsKey(todoStage)) {
                MutableTimeBoundProcessingStageWorkPackageImpl nextWorkPackage = new MutableTimeBoundProcessingStageWorkPackageImpl(openWork, Math.max(this.freedTimeSteps.get(todoStage), this.lowerTimeBound), this.upperTimeBound, minWork, openWork.getAmount());
                return Optional.of((Object)nextWorkPackage);
            }
            Optional<EligibleEntry> eligibleEntry = this.eligibleWorkTracker.getTimeStepForEligible(minWork - 0.01f, todoStage);
            if (!eligibleEntry.isPresent()) continue;
            float maxWork = ((EligibleEntry)eligibleEntry.get()).getEligibleAmount();
            MutableTimeBoundProcessingStageWorkPackageImpl nextWorkPackage = new MutableTimeBoundProcessingStageWorkPackageImpl(openWork, Math.max(((EligibleEntry)eligibleEntry.get()).getTimeStep(), this.lowerTimeBound), this.upperTimeBound, Math.min(maxWork, minWork), maxWork);
            return Optional.of((Object)nextWorkPackage);
        }
        return Optional.absent();
    }

    public static ItemSchedulingState createInstance(IUnstructuredItemSchedulingProblem problem) {
        EligibleWorkTracker eligibleWorkTracker = EligibleWorkTracker.createInstance(problem);
        HashMap freedSteps = Maps.newHashMap();
        freedSteps.put(problem.getWorkDemand().getSpecifiedStages().get(0), problem.getLowerTimeBound());
        PositivePrimitivesMap<IProcessingStage> stageToMinLoads = ItemSchedulingState.calculateStageWiseMinLoads(problem);
        return new ItemSchedulingState(problem.getWorkDemand(), MutableAggregatedWorkPackage.createInstance(problem.getWorkDemand()), eligibleWorkTracker, stageToMinLoads, Math.max(problem.getCausalReleaseTime(), problem.getLowerTimeBound()), problem.getUpperTimeBound(), problem.getId(), problem.getProjectStatistics(), freedSteps, problem.getProjectEpisode());
    }

    private static PositivePrimitivesMap<IProcessingStage> calculateStageWiseMinLoads(IUnstructuredItemSchedulingProblem problem) {
        List<IProcessingStage> stages = problem.getWorkDemand().getSpecifiedStages();
        MutablePositivePrimitivesMap<IProcessingStage> stageWiseMinLoads = RmCollectionUtils.newMutablePositiveMap(stages.size());
        for (IProcessingStage stage : stages) {
            float maxPoolStageSum = ItemSchedulingState.getMinLoadForStage(problem, stage);
            stageWiseMinLoads.put(stage, Math.max(0.1f, Math.min(problem.getMinWorkUnitsPerTeamInWorkSlot(), maxPoolStageSum)));
        }
        return stageWiseMinLoads;
    }

    private static float getMinLoadForStage(IUnstructuredItemSchedulingProblem problem, IProcessingStage stage) {
        IAggregatedWorkPackage workDemand = problem.getWorkDemand();
        Set<IResourceType> neededTypes = ((IProcessingStageWorkPackage)workDemand.getWorkPackageForStage(stage).get()).getResourceTypes();
        Set<IMutableResourcePool> resourcePools = problem.getMutableResourcePools();
        float maxPoolStageSum = Float.MIN_VALUE;
        for (IMutableResourcePool pool : resourcePools) {
            float poolStageSum = ItemSchedulingState.getMinWorkloadForPool(problem, neededTypes, pool);
            maxPoolStageSum = Math.max(maxPoolStageSum, poolStageSum);
        }
        return maxPoolStageSum;
    }

    private static float getMinWorkloadForPool(IUnstructuredItemSchedulingProblem problem, Set<IResourceType> neededTypes, IMutableResourcePool pool) {
        if (!pool.isWorkSlotStrict()) {
            return problem.getMinWorkUnitsPerTeamInWorkSlot();
        }
        float poolStageSum = 0.0f;
        MutablePositivePrimitivesMap<IMutableResource> schedulable = pool.getSchedulableWorkInTimeSlot(0);
        for (IMutableResource resource : schedulable.keySet()) {
            Set<IResourceType> availableTypes = resource.getResourceTypes();
            if (Sets.intersection(neededTypes, availableTypes).isEmpty()) continue;
            poolStageSum += schedulable.get(resource);
        }
        return poolStageSum;
    }
}

