/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.plugins.jira.websections;

import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.model.WebFragmentBuilder;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.jpo2.api.plans.Plan;
import org.apache.commons.lang.StringEscapeUtils;

class PlanWebItemProvider {
    private static final String WEB_SECTION = "plugins-jira-webitem/plugins-jira-websection-plans";
    private static final String DEFAULT_PLAN_TITLE = "Untitled plan";
    private final String baseUrl;
    private int index;

    public PlanWebItemProvider(String baseUrl) {
        this.baseUrl = baseUrl;
        this.index = 0;
    }

    public WebItem createPortfolio2WebItem(Plan plan, Optional<Long> scenarioId) {
        String id;
        String url;
        if (scenarioId.isPresent()) {
            url = String.format("%s/secure/PortfolioPlanView.jspa?id=%d&sid=%d", this.baseUrl, plan.getId(), scenarioId.get());
            id = String.format("plugins-jira-webitem-plan-%d-%d", plan.getId(), scenarioId.get());
        } else {
            url = String.format("%s/secure/PortfolioPlanView.jspa?id=%d", this.baseUrl, plan.getId());
            id = String.format("plugins-jira-webitem-plan-%d", plan.getId());
        }
        return new WebFragmentBuilder(this.index++).id(id).label(StringEscapeUtils.escapeHtml((String)((String)plan.getTitle().or((Object)DEFAULT_PLAN_TITLE)))).webItem(WEB_SECTION).url(url).build();
    }

    public WebItem createPortfolio1WebItem(IPlan plan) {
        String url = String.format("%s/secure/PortfolioPlan.jspa?id=%s#backlog", this.baseUrl, plan.getId());
        String id = String.format("plugins-jira-webitem-plan-%s", plan.getId());
        return new WebFragmentBuilder(this.index++).id(id).label(StringEscapeUtils.escapeHtml((String)((String)Objects.firstNonNull((Object)plan.getTitle(), (Object)DEFAULT_PLAN_TITLE)))).webItem(WEB_SECTION).url(url).build();
    }
}

