/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemStatus;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemType;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.AOSortableEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.ao.common.TransformerUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.SortOrderUtils;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.EntityInfoSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.MoveMode;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.ntom.sql.WorkItemToResourceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.plans.AOPlan;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.sql.StreamToReleaseSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.WorkItemInheritanceOperator;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.DeleteSortAction;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.WorkItemCountSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.WorkItemDependencySQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.WorkItemEstimateSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.WorkItemHierarchySQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.WorkItemPropertySQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.WorkItemRelationSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.WorkItemSelectSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.WorkItemStatusSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.WorkItemStreamSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.WorkItemSelectQueryBuilder;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.sorting.WorkItemSortOrderUpdateSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.sorting.WorkItemSortingSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.port.IKeyResolver;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioResourcePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.SyncInformation;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressConfiguration;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.filter.WorkItemSolutionFilterResult;
import com.radiantminds.roadmap.common.rest.entities.filter.RestWorkItemFilter;
import com.radiantminds.roadmap.common.rest.entities.workitems.dependencies.RestWorkItemDependencies;
import com.radiantminds.roadmap.common.stats.MonitoredCallResult;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortfolioActiveObjectsWorkItemPersistence
extends AOSortableEntityPersistence<IWorkItem, AOWorkItem>
implements PortfolioWorkItemPersistence {
    private final ActiveObjectsUtilities activeObjectsUtilities;
    private final PortfolioPlanPersistence planPersistence;
    private final PortfolioResourcePersistence resourcePersistence;
    private final PortfolioEstimatePersistence estimatePersistence;
    private final WorkItemExtension workItemExtension;
    private final WorkItemRelationSQL workItemRelationSQL;
    private final WorkItemToResourceSQL workItemToResourceSQL;
    private final WorkItemStreamSQL workItemStreamSQL;
    private final WorkItemDependencySQL workItemDependencySQL;
    private final WorkItemEstimateSQL workItemEstimateSQL;
    private final WorkItemSortingSQL workItemSortingSQL;
    private final WorkItemHierarchySQL workItemHierarchySQL;
    private final WorkItemSelectSQL workItemSelectSQL;
    private final WorkItemSortOrderUpdateSQL workItemSortOrderUpdateSQL;
    private final WorkItemCountSQL workItemCountSQL;
    private final WorkItemStatusSQL workItemStatusSQL;
    private final WorkItemPropertySQL workItemPropertySQL;
    private final StreamToReleaseSQL streamToReleaseSQL;
    private final EntityInfoSQL entityInfoSQL;
    private final SortOrderUtils sortOrderUtils;
    private final WorkItemInheritanceOperator inheritanceOperator;

    @Autowired
    public PortfolioActiveObjectsWorkItemPersistence(ActiveObjectsUtilities activeObjectsUtilities, PortfolioPlanPersistence planPersistence, PortfolioResourcePersistence resourcePersistence, PortfolioEstimatePersistence estimatePersistence, WorkItemExtension workItemExtension) {
        super(activeObjectsUtilities, IWorkItem.class, AOWorkItem.class);
        this.activeObjectsUtilities = activeObjectsUtilities;
        this.planPersistence = planPersistence;
        this.resourcePersistence = resourcePersistence;
        this.estimatePersistence = estimatePersistence;
        this.workItemExtension = workItemExtension;
        this.workItemRelationSQL = new WorkItemRelationSQL(activeObjectsUtilities);
        this.workItemToResourceSQL = new WorkItemToResourceSQL(activeObjectsUtilities, resourcePersistence);
        this.workItemStreamSQL = new WorkItemStreamSQL(activeObjectsUtilities, this);
        this.workItemDependencySQL = new WorkItemDependencySQL(activeObjectsUtilities);
        this.workItemEstimateSQL = new WorkItemEstimateSQL(activeObjectsUtilities);
        this.workItemSortingSQL = new WorkItemSortingSQL(activeObjectsUtilities);
        this.workItemHierarchySQL = new WorkItemHierarchySQL(activeObjectsUtilities);
        this.workItemSelectSQL = new WorkItemSelectSQL(activeObjectsUtilities);
        this.workItemCountSQL = new WorkItemCountSQL(activeObjectsUtilities);
        this.workItemSortOrderUpdateSQL = new WorkItemSortOrderUpdateSQL(activeObjectsUtilities);
        this.workItemStatusSQL = new WorkItemStatusSQL(activeObjectsUtilities);
        this.workItemPropertySQL = new WorkItemPropertySQL(activeObjectsUtilities);
        this.streamToReleaseSQL = new StreamToReleaseSQL(activeObjectsUtilities);
        this.entityInfoSQL = new EntityInfoSQL(activeObjectsUtilities);
        this.sortOrderUtils = new SortOrderUtils(activeObjectsUtilities);
        this.inheritanceOperator = new WorkItemInheritanceOperator(this);
    }

    @Override
    public Class<? extends IEntityPersistence> getPersistenceType() {
        return PortfolioWorkItemPersistence.class;
    }

    @Override
    protected void transform(IWorkItem source, AOWorkItem target) throws Exception {
        TransformerUtils.transformDescribable(source, target);
        TransformerUtils.transformSortable(source, target);
        target.setType(source.getType());
        target.setStatus(source.getStatus());
        target.setHasOriginalEstimates(source.getHasOriginalEstimates());
        if (source.getEarliestStart() != null) {
            target.setEarliestStart(source.getEarliestStart());
        }
        if (source.getTargetStart().isPresent()) {
            target.setTargetStart((Long)source.getTargetStart().orNull());
        }
        if (source.getTargetEnd().isPresent()) {
            target.setTargetEnd((Long)source.getTargetEnd().orNull());
        }
        if (source.getParent() != null) {
            target.setParent((IWorkItem)this.get(source.getParent().getId()));
        }
        if (source.getPlan() != null) {
            target.setPlan((IPlan)this.planPersistence.get(source.getPlan().getId()));
        }
    }

    @Override
    protected void onBeforeCreate(IWorkItem entity) throws PersistenceException {
        super.onBeforeCreate(entity);
        if (entity.getStatus() == null) {
            entity.setStatus(WorkItemStatus.OPEN.value());
        }
        if (entity.getHasOriginalEstimates() == null) {
            entity.setHasOriginalEstimates(false);
        }
    }

    @Override
    public void onAfterCreate(IWorkItem entity) throws PersistenceException {
        if (entity.getParent() != null && entity.getParent().getOrderRangeIdentifier() != null && !WorkItems.Types.INITIATIVE.equals(entity.getParent().getType())) {
            try {
                Long sortOrder = entity.getParent().getSortOrder();
                this.sortOrderUtils.setSortOrder(entity.getId(), AOWorkItem.class, sortOrder, entity.getOrderRangeIdentifier());
                entity.setSortOrder(sortOrder);
                this.sortOrderUtils.clearSortOrderDontCascade(entity.getParent().getId(), AOWorkItem.class);
            }
            catch (SQLException ex) {
                throw new PersistenceException("Failed to clear sort order for work item '" + entity.getParent().getId() + "'", ex);
            }
        } else {
            super.onAfterCreate(entity);
        }
    }

    @Override
    public boolean delete(String id, boolean inCascade) throws PersistenceException {
        boolean retVal;
        try {
            this.workItemToResourceSQL.clearResourceAssignmentsForWorkItems(Lists.newArrayList((Object[])new String[]{id}), null);
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to cascade delete resource assignments for work item '" + id + "'", ex);
        }
        try {
            this.workItemRelationSQL.deleteAllReplanningRelations(id);
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to cascade delete replannings for work item '" + id + "'", ex);
        }
        try {
            this.workItemStreamSQL.reactToChildDeletion(id);
        }
        catch (Exception ex) {
            throw new PersistenceException("Failed to react to possible child deletion of child '" + id + "'", ex);
        }
        try {
            DeleteSortAction action = this.workItemSortingSQL.reactToChildDeletion(id);
            if (action != null && !inCascade) {
                this.sortOrderUtils.clearSortOrderDontCascade(id, this.getAoClazz());
            } else {
                this.sortOrderUtils.clearAndAdaptSortOrder(id, this.getAoClazz());
            }
            retVal = this.getUtils().delete(this.getEntityClass(), this.getAoClazz(), id);
            if (action != null) {
                this.sortOrderUtils.setSortOrder(action.getParentId(), AOWorkItem.class, action.getSetTo(), action.getOrderRangeIdentifier());
            }
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to set sort order on parent of work item '" + id + "'", ex);
        }
        try {
            this.workItemDependencySQL.removeAllDependenciesForWorkItem(id);
        }
        catch (SQLException ex) {
            throw new PersistenceException("Failed to cascade delete dependency entries for work item '" + id + "'", ex);
        }
        return retVal;
    }

    @Override
    public MonitoredCallResult<? extends List<? extends IWorkItem>> listFullWorkItemsForPlan(String planId, boolean includeReplanning, ProgressConfiguration progressConfiguration) throws Exception {
        return WorkItemSelectQueryBuilder.create(this.activeObjectsUtilities, this.resourcePersistence, this.workItemExtension).withPlanId(planId).withDone(true).withDoneDependencies(true).withReplanning(includeReplanning).enrichWithExtensions(progressConfiguration).execute();
    }

    @Override
    public MonitoredCallResult<? extends List<? extends IWorkItem>> listFullWorkItemsForPlanAndFilter(String planId, boolean includeReplanning, ProgressConfiguration progressConfiguration, RestWorkItemFilter filter, WorkItemSolutionFilterResult solutionFilterResult) throws Exception {
        return this.createFilterQueryBuilder(planId, includeReplanning, progressConfiguration, filter, solutionFilterResult).execute();
    }

    WorkItemSelectQueryBuilder createFilterQueryBuilder(String planId, boolean includeReplanning, ProgressConfiguration progressConfiguration, RestWorkItemFilter filter, WorkItemSolutionFilterResult solutionFilterResult) {
        WorkItemSelectQueryBuilder workItemSelectQueryBuilder = WorkItemSelectQueryBuilder.create(this.activeObjectsUtilities, this.resourcePersistence, this.workItemExtension).withPlanId(planId).withDone((Boolean)Optional.fromNullable((Object)filter.getShowCompleted()).or((Object)false)).withDoneDependencies(true).withFilter(filter, solutionFilterResult).withReplanning(includeReplanning);
        if (!((Boolean)Optional.fromNullable((Object)filter.isEnrichmentSkipped()).or((Object)false)).booleanValue()) {
            workItemSelectQueryBuilder.enrichWithExtensions(progressConfiguration);
        }
        return workItemSelectQueryBuilder;
    }

    @Override
    public Map<String, String> getAllWorkItemsWithParentRelation(String planId) throws SQLException {
        return this.workItemHierarchySQL.getAllWorkItemsWithParentRelation(planId);
    }

    @Override
    public List<? extends IWorkItem> listPlainWorkItemsForPlan(String planId) throws Exception {
        return WorkItemSelectQueryBuilder.create(this.activeObjectsUtilities, this.resourcePersistence, this.workItemExtension).withPlanId(planId).execute().getResult();
    }

    @Override
    public List<? extends IWorkItem> listPlainWorkItemsForPlanIncludingDone(String planId) throws Exception {
        return WorkItemSelectQueryBuilder.create(this.activeObjectsUtilities, this.resourcePersistence, this.workItemExtension).withPlanId(planId).withDone(true).withDoneDependencies(true).execute().getResult();
    }

    @Override
    public List<? extends IWorkItem> listPlainWorkItemsForPlanForIds(String planId, List<String> ids, boolean includeReplanning) throws Exception {
        return WorkItemSelectQueryBuilder.create(this.activeObjectsUtilities, this.resourcePersistence, this.workItemExtension).withPlanId(planId).withSpecificIdRange(ids).withDone(true).withDoneDependencies(true).withReplanning(includeReplanning).execute().getResult();
    }

    @Override
    public List<IWorkItem> listWorkItemStubsWithType(String planId, int type, boolean includeDone) throws Exception {
        return this.workItemSelectSQL.listWorkItemDescriptionsWithType(planId, type, includeDone);
    }

    @Override
    public Map<String, Long> getEpicsSortOrder(String planId, boolean excludeCompleted) throws Exception {
        return this.workItemSelectSQL.getEpicsSortOrder(planId, excludeCompleted);
    }

    @Override
    public int countChildren(String workItemId) throws SQLException {
        return this.workItemSelectSQL.countChildren(workItemId);
    }

    @Override
    public Integer getWorkItemType(String id) throws SQLException {
        return this.workItemSelectSQL.getWorkItemType(id);
    }

    @Override
    public Long countAllForPlan(String planId) throws SQLException {
        return this.workItemCountSQL.countAllForPlan(planId);
    }

    @Override
    public String getParentId(String id) throws SQLException {
        return this.workItemSelectSQL.getParentId(id);
    }

    @Override
    public void setStreamReleaseAssignment(String workItemId, String streamId, String releaseId, boolean replanning) throws SQLException {
        if (replanning) {
            this.setReplanningStream(workItemId, streamId);
            this.setReplanningRelease(workItemId, releaseId);
        } else {
            this.setStream(workItemId, streamId);
            this.setRelease(workItemId, releaseId);
        }
    }

    @Override
    public boolean validateStreamReleaseAssignment(String streamId, String releaseId) throws SQLException {
        return this.streamToReleaseSQL.validateAssignment(streamId, releaseId);
    }

    @Override
    public void moveWorkItemsToStream(String id, String alternateStreamId) throws SQLException {
        this.workItemStreamSQL.moveWorkItemsToStream(id, alternateStreamId);
    }

    @Override
    public void clearEstimatesForWorkItem(String workItemId, boolean replanning, boolean original) throws SQLException {
        this.workItemEstimateSQL.clearEstimatesForWorkItem(workItemId, replanning, original);
    }

    @Override
    public boolean hasReplanningEstimates(String id) throws SQLException {
        return this.workItemEstimateSQL.hasReplanningEstimates(id);
    }

    @Override
    public boolean validateTeamSprintResourceAssignment(String teamId, String sprintId, List<String> resourceIds) throws SQLException, PersistenceException {
        return this.validateResourceAssignments(teamId, resourceIds) && this.validateSprintAssignment(teamId, sprintId);
    }

    @Override
    public void setTeamSprintResourceAssignment(String workItemId, String teamId, String sprintId, List<String> resourceIds, boolean replanning) throws SQLException {
        if (replanning) {
            this.setReplanningTeam(workItemId, teamId);
        } else {
            this.setTeam(workItemId, teamId);
            this.setSprint(workItemId, sprintId);
        }
        this.setResources(workItemId, resourceIds, replanning);
    }

    @Override
    public boolean validateSprintAssignment(String teamId, String sprintId) throws SQLException, PersistenceException {
        return this.workItemRelationSQL.validateSprintAssignment(teamId, sprintId);
    }

    @Override
    public void setSprintAssignment(String workItemId, String teamId, String sprintId, boolean replanning) throws SQLException {
        if (replanning) {
            this.setReplanningTeam(workItemId, teamId);
        } else {
            this.setTeam(workItemId, teamId);
            this.setSprint(workItemId, sprintId);
        }
    }

    @Override
    public boolean validateResourceAssignments(String teamId, List<String> resourceIds) throws SQLException {
        return this.workItemToResourceSQL.validateResourceAssignments(teamId, resourceIds);
    }

    @Override
    public void setResourceAssignments(String workItemId, String teamId, List<String> resourceIds, boolean replanning) throws SQLException {
        if (replanning) {
            this.setReplanningTeam(workItemId, teamId);
        } else {
            this.setTeam(workItemId, teamId);
        }
        this.setResources(workItemId, resourceIds, replanning);
    }

    @Override
    public Set<String> getResourceAssignmentsForWorkItem(String workItemId, boolean replanning) throws SQLException {
        return this.workItemToResourceSQL.getResourceAssignmentsForWorkItem(workItemId, replanning);
    }

    @Override
    public void deleteResourceAssignments(List<String> ids, boolean replanning) throws SQLException {
        this.workItemToResourceSQL.clearResourceAssignmentsForWorkItems(ids, replanning);
    }

    @Override
    public void replanResourceAssignments(List<String> ids) throws SQLException {
        this.workItemToResourceSQL.replanResourceAssignments(ids);
    }

    @Override
    public String getIdWithHighestSortOrder(String planId, String orderRangeId) throws SQLException {
        return this.workItemSortingSQL.getIdWithHighestSortOrder(planId, orderRangeId);
    }

    @Override
    public String getIdWithHighestSortOrderInEpic(String epicId) throws SQLException {
        return this.workItemSortingSQL.getIdWithHighestSortOrderInEpic(epicId);
    }

    @Override
    public void move(String id, String anchor, MoveMode mode) throws SQLException {
        this.workItemSortOrderUpdateSQL.move(id, anchor, mode);
    }

    @Override
    public void setStream(String workItemId, String streamId) throws SQLException {
        this.workItemRelationSQL.setStream(workItemId, streamId);
    }

    @Override
    public void setRelease(String workItemId, String releaseId) throws SQLException {
        this.workItemRelationSQL.setRelease(workItemId, releaseId);
    }

    @Override
    public void setTeam(String workItemId, String teamId) throws SQLException {
        this.workItemRelationSQL.setTeam(workItemId, teamId);
    }

    @Override
    public void setSprint(String workItemId, String sprintId) throws SQLException {
        this.workItemRelationSQL.setSprint(workItemId, sprintId);
    }

    @Override
    public void clearSprintAssignments(List<String> sprintIds) throws SQLException {
        this.workItemRelationSQL.clearSprintAssignments(sprintIds);
    }

    @Override
    public void setResources(String workItemId, List<String> resourceIds, boolean replanning) throws SQLException {
        this.workItemToResourceSQL.clearResourceAssignmentsForWorkItems(Lists.newArrayList((Object[])new String[]{workItemId}), replanning);
        if (resourceIds != null && resourceIds.size() > 0) {
            this.workItemToResourceSQL.setResourceAssignment(workItemId, resourceIds, replanning);
        }
    }

    @Override
    public void setParent(String id, String parent) throws SQLException {
        this.workItemRelationSQL.setParent(id, parent);
    }

    @Override
    public void setDependencies(String id, List<String> prerequisites) throws SQLException {
        this.workItemDependencySQL.setDependencies(id, prerequisites);
    }

    @Override
    public void removeDependency(String dependent, String dependee) throws SQLException {
        this.workItemDependencySQL.removeDependency(dependent, dependee);
    }

    @Override
    public RestWorkItemDependencies getDependencies(String id, boolean includeDone) throws SQLException {
        return new RestWorkItemDependencies(this.workItemDependencySQL.getRequires(id, includeDone), this.workItemDependencySQL.getRequiredBy(id, includeDone));
    }

    @Override
    public void setReplanningTeam(String workItemId, String teamId) throws SQLException {
        this.workItemRelationSQL.setReplanningRelation(workItemId, "team", teamId);
    }

    @Override
    public void deleteReplanningTeam(String workItemId) throws SQLException {
        this.workItemRelationSQL.deleteReplanningRelation(workItemId, "team");
    }

    @Override
    public void setReplanningRelease(String workItemId, String releaseId) throws SQLException {
        this.workItemRelationSQL.setReplanningRelation(workItemId, "release", releaseId);
    }

    @Override
    public void deleteReplanningRelease(String workItemId) throws SQLException {
        this.workItemRelationSQL.deleteReplanningRelation(workItemId, "release");
    }

    @Override
    public void setReplanningStream(String workItemId, String streamId) throws SQLException {
        this.workItemRelationSQL.setReplanningRelation(workItemId, "stream", streamId);
    }

    @Override
    public void deleteReplanningStream(String workItemId) throws SQLException {
        this.workItemRelationSQL.deleteReplanningRelation(workItemId, "stream");
    }

    @Override
    public String getReplanningRelationTargetId(String targetType, String workItemId) throws SQLException {
        return this.workItemRelationSQL.getReplanningRelationTargetId(targetType, workItemId);
    }

    @Override
    public String getReplanningRelationId(String targetType, String workItemId) throws SQLException {
        return this.workItemRelationSQL.getReplanningRelationId(targetType, workItemId);
    }

    @Override
    public List<String> getReplanningRelationWorkItemIds(String targetType, List<String> workItemIds) throws SQLException {
        return this.workItemRelationSQL.getReplanningRelationWorkItemIds(targetType, workItemIds);
    }

    @Override
    public Set<String> getItemsWithReplanningEstimates(String planId) throws SQLException {
        return this.workItemEstimateSQL.getItemsWithReplanningEstimates(planId);
    }

    @Override
    public void setStatus(String workItemId, Integer status) throws SQLException {
        this.workItemStatusSQL.setStatus(workItemId, status);
    }

    @Override
    public void setReplanningStatus(String workItemId, Integer status) throws SQLException {
        this.workItemStatusSQL.setReplanningStatus(workItemId, status);
    }

    @Override
    public void deleteReplanningStatus(String workItemId) throws SQLException {
        this.workItemStatusSQL.deleteReplanningStatus(workItemId);
    }

    @Override
    public void clearProperties(String id) throws SQLException {
        this.workItemPropertySQL.clearProperties(id);
    }

    @Override
    public void inheritStreamsUpwards(String id) throws Exception {
        this.workItemStreamSQL.reactToChildDeletion(id);
    }

    @Override
    public boolean isInitiative(String id) throws SQLException {
        return WorkItemType.Initiative.equals((Object)WorkItemType.fromCode(this.getWorkItemType(id)));
    }

    @Override
    public Set<IWorkItem> tryInheritTheme(String themeId, IWorkItem workItem) throws SQLException, PersistenceException {
        return this.inheritanceOperator.tryInheritTheme(themeId, workItem);
    }

    @Override
    public void selectAllForPlan(AOQueryGenerator generator, String planId, boolean inOrder) throws SQLException {
        generator.withTable(AOWorkItem.class, "w").withTable(AOWorkItem.class, "w2").select().raw("*").from("w").where().col("w", "aoplan").eq().numeric(planId);
        if (inOrder) {
            generator.orderBy();
            PortfolioActiveObjectsWorkItemPersistence.typeOrderBlock(generator);
            generator.raw(", COALESCE(").col("w", "sortOrder").raw(",").raw("(").select().raw("MIN(").col("w2", "sortOrder").raw(")").from("w2").where().col("w2", "aoParent").eq().colId("w").raw(")").raw("), ");
            generator.col("w", "type");
        }
    }

    private static void typeOrderBlock(AOQueryGenerator generator) {
        generator.raw("(").raw("CASE").raw("WHEN").col("w", "type").eq().numeric(WorkItems.Types.INITIATIVE).raw("THEN").numeric(0).raw("WHEN").col("w", "type").eq().numeric(WorkItems.Types.EPIC).raw("THEN").numeric(1).raw("WHEN").col("w", "type").eq().numeric(WorkItems.Types.STORY).raw("THEN").numeric(2).raw("ELSE").nullValueAsInt().raw("END").raw(")");
    }

    @Override
    public IKeyResolver getForeignKeyResolver(String method) {
        if ("getOrderRangeIdentifier".equals(method)) {
            return new WorkItemOrderRangeForeignKeyResolver();
        }
        return super.getForeignKeyResolver(method);
    }

    @Override
    public void reactToCreationOfFirstChild(String id, boolean clearSortOrder) throws SQLException, PersistenceException {
        if (clearSortOrder && !WorkItems.Types.INITIATIVE.equals(this.getWorkItemType(id))) {
            this.sortOrderUtils.clearAndAdaptSortOrder(id, AOWorkItem.class);
        }
        this.clearPropertiesOfWorkItem(id);
    }

    @Override
    public Optional<String> clearPropertiesOfWorkItem(String id) throws SQLException, PersistenceException {
        Optional<String> themeId = this.tryGetThemeId(id);
        this.setTeam(id, null);
        this.setRelease(id, null);
        this.setStream(id, null);
        this.setTheme(id, null);
        this.deleteReplanningRelease(id);
        this.deleteReplanningTeam(id);
        this.deleteReplanningStream(id);
        this.clearProperties(id);
        this.deleteResourceAssignments(Lists.newArrayList((Object[])new String[]{id}), true);
        this.deleteResourceAssignments(Lists.newArrayList((Object[])new String[]{id}), false);
        this.estimatePersistence.clearEstimates(id);
        return themeId;
    }

    @Override
    public Optional<String> tryGetThemeId(String itemId) throws PersistenceException {
        IWorkItem item = (IWorkItem)this.get(itemId);
        if (item == null) {
            return Optional.absent();
        }
        return item.getThemeId();
    }

    @Override
    public void reactToCreationOfFirstChild(String id) throws SQLException, PersistenceException {
        this.reactToCreationOfFirstChild(id, true);
    }

    @Override
    public void setTheme(String workItemId, String themeId) throws SQLException {
        this.workItemRelationSQL.setTheme(workItemId, themeId);
    }

    @Override
    public EntityInfo getEntityInfo(String id) throws SQLException {
        return this.entityInfoSQL.getEntityInfo(id, AOWorkItem.class, new EntityInfoSQL.ParentRelationship[0]);
    }

    @Override
    public List<EntityInfo> getEntityInfos(Collection<String> ids) throws SQLException {
        return this.entityInfoSQL.getEntityInfo(ids, AOWorkItem.class, new EntityInfoSQL.ParentRelationship[0]);
    }

    @Override
    public Map<String, SyncInformation> getSyncInformation(Collection<String> workItemIDs, Collection<String> acceptedWorkItemTypes) throws SQLException {
        return this.workItemSelectSQL.getSyncInformation(workItemIDs, acceptedWorkItemTypes);
    }

    private class WorkItemOrderRangeForeignKeyResolver
    implements IKeyResolver {
        private WorkItemOrderRangeForeignKeyResolver() {
        }

        @Override
        public Class<?> resolve(String dependency) {
            return AOPlan.class;
        }

        @Override
        public String getPrefix(String dependency) {
            return WorkItems.OrderRangeIdentifiers.forType(dependency) + "-";
        }
    }
}

