/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers;

import com.atlassian.rm.common.bridges.jira.license.LicenseData;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.common.IIdentifiable;
import com.radiantminds.roadmap.common.data.persistence.PersistenceIndex;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.licenses.LicenseExtension;
import com.radiantminds.roadmap.common.handlers.BadDeveloperException;
import com.radiantminds.roadmap.common.handlers.BulkEntityContext;
import com.radiantminds.roadmap.common.handlers.ClientIdCache;
import com.radiantminds.roadmap.common.handlers.ContextAwareAnnotations;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.EntityParam;
import com.radiantminds.roadmap.common.handlers.EntityParamExtractor;
import com.radiantminds.roadmap.common.handlers.NotAuthorizedException;
import com.radiantminds.roadmap.common.handlers.NotFoundException;
import com.radiantminds.roadmap.common.handlers.PluginLevelPermissionChecker;
import com.radiantminds.roadmap.common.handlers.SecureBulkEntityContextInitializer;
import com.radiantminds.roadmap.common.handlers.SecureEntityContextInitializer;
import com.radiantminds.roadmap.common.handlers.SecurityAnnotations;
import com.radiantminds.roadmap.common.handlers.VersionMismatchException;
import com.radiantminds.roadmap.common.permissions.PlanPermissions;
import com.radiantminds.roadmap.common.permissions.PluginPermissions;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.spi.dispatch.RequestDispatcher;
import java.sql.SQLException;
import javax.ws.rs.core.Response;

public class ContextAwareSecureRequestDispatcher<U extends IIdentifiable>
implements RequestDispatcher {
    private static final int PAYMENT_REQUIRED_STATUS = 402;
    private final LicenseExtension licenseExtension;
    private final PersistenceIndex persistenceIndex;
    private final PluginPermissions pluginPermissionHandler;
    private final RequestDispatcher dispatcher;
    private final SecurityAnnotations securityConfig;
    private final ContextAwareAnnotations contextConfig;
    private final SecureBulkEntityContextInitializer bulkEntityContextInitializer;
    private final SecureEntityContextInitializer entityContextInitializer;
    private final EntityParamExtractor entityParamExtractor;
    private final ClientIdCache clientIdCache;

    ContextAwareSecureRequestDispatcher(LicenseExtension licenseExtension, PersistenceIndex persistenceIndex, PluginPermissions pluginPermissionHandler, RequestDispatcher dispatcher, SecurityAnnotations securityConfig, ContextAwareAnnotations contextConfig, SecureBulkEntityContextInitializer bulkEntityContextInitializer, SecureEntityContextInitializer entityContextInitializer, EntityParamExtractor entityParamExtractor, ClientIdCache clientIdCache) {
        this.licenseExtension = licenseExtension;
        this.persistenceIndex = persistenceIndex;
        this.pluginPermissionHandler = pluginPermissionHandler;
        this.dispatcher = dispatcher;
        this.securityConfig = securityConfig;
        this.contextConfig = contextConfig;
        this.bulkEntityContextInitializer = bulkEntityContextInitializer;
        this.entityContextInitializer = entityContextInitializer;
        this.entityParamExtractor = entityParamExtractor;
        this.clientIdCache = clientIdCache;
    }

    public void dispatch(Object resource, HttpContext context) {
        if (this.findAndSetLicenseViolationResponse(context)) {
            return;
        }
        try {
            Optional entityContext = this.entityParamExtractor.tryGetAndSetEntityContext(context);
            Optional bulkEntityContext = this.entityParamExtractor.tryGetAndSetBulkEntityContext(context);
            this.checkPluginLevelPermissions(this.isEntityAware(entityContext, bulkEntityContext));
            Optional<Response> errorResponse = this.initializeEntityContext(entityContext, bulkEntityContext);
            if (errorResponse.isPresent()) {
                context.getResponse().setResponse((Response)errorResponse.get());
                return;
            }
            this.dispatcher.dispatch(resource, context);
        }
        catch (NotFoundException e) {
            context.getResponse().setResponse(ResponseBuilder.badRequest(RestMessaging.entityNotFound()));
        }
        catch (VersionMismatchException e) {
            context.getResponse().setResponse(ResponseBuilder.conflict(RestMessaging.error("version-conflict", String.format("Version mismatch; your version: '%d', server version: '%d'", e.getExceptedVersion(), e.getActualVersion()))));
        }
        catch (NotAuthorizedException e) {
            context.getResponse().setResponse(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
        }
        catch (Exception ex) {
            throw new ContainerException((Throwable)ex);
        }
    }

    private Optional<Response> initializeEntityContext(Optional<EntityContext<U>> entityContext, Optional<BulkEntityContext<U>> bulkEntityContext) throws Exception {
        Optional<IEntityPersistence<U>> entityPersistence = this.tryGetEntityPersistence(entityContext, bulkEntityContext);
        if (bulkEntityContext.isPresent()) {
            return this.bulkEntityContextInitializer.initialize((BulkEntityContext)bulkEntityContext.get(), (IEntityPersistence)entityPersistence.orNull());
        }
        if (entityContext.isPresent()) {
            this.entityContextInitializer.initialize((EntityContext)entityContext.get(), (IEntityPersistence)entityPersistence.orNull(), this.clientIdCache);
        }
        return Optional.absent();
    }

    private void checkPluginLevelPermissions(boolean entityAware) throws NotAuthorizedException {
        if (!entityAware || this.securityConfig.requiresPluginLevelAuth()) {
            try {
                PluginLevelPermissionChecker.check(this.securityConfig, this.pluginPermissionHandler);
            }
            catch (SQLException ex) {
                throw new ContainerException((Throwable)ex);
            }
        }
    }

    private Optional<IEntityPersistence<U>> tryGetEntityPersistence(Optional<EntityContext<U>> entityContext, Optional<BulkEntityContext<U>> bulkEntityContext) {
        if (this.isEntityAware(entityContext, bulkEntityContext)) {
            EntityParam entityParam = this.contextConfig.getEntityParam();
            Class<? extends IEntityPersistence<?>> entityPersistenceClass = entityParam.value();
            IEntityPersistence<?> entityPersistence = this.persistenceIndex.getBeanFromContext(entityPersistenceClass);
            if (entityPersistence == null) {
                throw new BadDeveloperException("No entity persistence found for " + entityPersistenceClass);
            }
            return Optional.of(entityPersistence);
        }
        return Optional.absent();
    }

    private boolean isEntityAware(Optional<EntityContext<U>> entityContext, Optional<BulkEntityContext<U>> bulkEntityContext) {
        return entityContext.isPresent() || bulkEntityContext.isPresent();
    }

    private boolean findAndSetLicenseViolationResponse(HttpContext context) {
        LicenseData licenseData;
        if (this.licenseExtension != null && !(licenseData = this.licenseExtension.getLicenseData()).isValid()) {
            context.getResponse().setResponse(Response.status((int)402).entity((Object)licenseData.getMessage()).build());
            return true;
        }
        return false;
    }

    public static <U extends IIdentifiable> RequestDispatcher createInstance(AbstractResourceMethod abstractResourceMethod, RequestDispatcher originalDispatcher, LicenseExtension licenseExtension, PortfolioPlanPersistence planPersistence, PersistenceIndex persistenceIndex, PluginPermissions pluginPermissionHandler, PlanPermissions planPermissionHandler, ClientIdCache clientIdCache) {
        SecurityAnnotations securityConfig = new SecurityAnnotations(abstractResourceMethod);
        ContextAwareAnnotations contextConfig = new ContextAwareAnnotations(abstractResourceMethod);
        return new ContextAwareSecureRequestDispatcher<U>(licenseExtension, persistenceIndex, pluginPermissionHandler, originalDispatcher, securityConfig, contextConfig, new SecureBulkEntityContextInitializer(planPersistence, pluginPermissionHandler, planPermissionHandler, securityConfig), new SecureEntityContextInitializer(planPersistence, pluginPermissionHandler, planPermissionHandler, securityConfig), new EntityParamExtractor(contextConfig), clientIdCache);
    }
}

